<?php

namespace App\Models;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ParItem extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory,SoftDeletes;

    protected $table = 'par_item';
    protected $primaryKey = 'idpar_item';
    public $timestamps = false;

    const CREATED_AT = 'fecha_creacion';
    const UPDATED_AT = 'fecha_modificacion';
    const DELETED_AT = 'fecha_eliminacion';

    const CREATED_BY = 'usuario_creacion';
    const UPDATED_BY = 'usuario_modificacion';
    const DELETED_BY = 'usuario_eliminacion';

    protected $dates = ['fecha_eliminacion','usuario_eliminacion','eliminado'];
    //excluir o incluir los campos que deseas auditar
    protected $auditInclude = [
        'usuario_creacion', 'fecha_creacion',
        'usuario_modificacion', 'fecha_modificacion',
        'usuario_eliminacion', 'fecha_eliminacion',
        'nombre', 'id_grupo', 'eliminado', 'estado',
    ];

    public static function boot()
    {
        parent::boot();
        
       // Ahora solo necesitamos manejar los campos de usuario
        static::creating(function ($model) {
            $model->{self::CREATED_BY} = auth()->check() ? auth()->user()->name : null;
            $model->{self::CREATED_AT} = now(); 
        });
        
        static::updating(function ($model) {
            $model->{self::UPDATED_BY} = auth()->check() ? auth()->user()->name : null;
            $model->{self::UPDATED_AT} = now();
        });
        
        // Para la eliminación suave
        static::deleting(function ($model) {
            if (!$model->isForceDeleting()) {
                $model->{self::DELETED_BY} = auth()->check() ? auth()->user()->name : null;
                $model->eliminado = true;
                $model->save(); // Guardamos para que se apliquen estos cambios
            }
        });
    }

    public function delete()
    {
        // Actualizamos los registros relacionados si no es una eliminación forzada
        if (!$this->isForceDeleting()) {
            $usuarioActual = auth()->check() ? auth()->user()->name : null;
            $fechaActual = now();
            
            DB::table('rep_formulariocontenido')
                ->where('idrep_formularioseccion', $this->idrep_formularioseccion)
                ->whereNull(self::DELETED_AT)
                ->update([
                    self::DELETED_BY => $usuarioActual,
                    self::DELETED_AT => $fechaActual,
                    'eliminado' => true
                ]);
        }
        
        return parent::delete();
    }

    public function grupo(){
        return $this->belongsTo(ParItem::class,'id_grupo');
    }

    public function ubicacion(){
        return $this->belongsTo(RepFormulariocontenido::class,'idpar_item');
    }
    
}
