<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ParEmpresa extends Model
{
    use HasFactory;

    protected $table = 'par_empresa';
    protected $primaryKey = 'idpar_empresa';

    public $timestamps = false;

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->usuario_creacion = auth()->user()->name ?? 'sistema'; // O 'sistema' si no hay usuario autenticado
            $model->fecha_creacion = now();
        });

        static::updating(function ($model) {
            $model->usuario_modificacion = auth()->user()->name ?? 'sistema';
            $model->fecha_modificacion = now();
        });
    }

}
