<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TipoFormularioRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = [
            'nombre' => 'required|string|max:255',
            'slug' => 'required|string|max:255',
            'descripcion' => 'required|string|max:1000',
            'tipo' => 'required|in:FORMULARIO,ENCUESTA',
            'orientacion_impresion' => 'required|in:portrait,landscape',
            'color_fondo' => 'required|string',
            'color_texto' => 'nullable|string',
            'color_subtitulo' => 'required|string',
            'color_titulo' => 'required|string',
            'codigo' => 'nullable|string|max:150',
            'descripcion_campo_obligatorio' => 'required|string|max:255',
            'mensaje_de_llenado_formulario' => 'required',
            'mensaje_de_formulario_deshabilitado' => 'required',
        ];

        // Si estamos actualizando
        if ($this->isMethod('PUT') || $this->isMethod('PATCH')) {
            // Logo solo si se envía uno nuevo
            if ($this->hasFile('logo')) {
                $rules['logo'] = 'image|mimes:jpg,jpeg,png,gif|max:2048';
            }

            // Fondo también opcional y condicional
            if ($this->hasFile('fondo')) {
                $rules['fondo'] = 'image|mimes:jpg,jpeg,png,gif|max:2048';
            }

        } else {
            // En creación, logo es obligatorio
            $rules['logo'] = 'required|image|mimes:jpg,jpeg,png,gif|max:2048';

            // Fondo sigue siendo opcional
            if ($this->hasFile('fondo')) {
                $rules['fondo'] = 'image|mimes:jpg,jpeg,png,gif|max:2048';
            }
        }

        return $rules;
    }

    public function messages()
    {
        return [
            'logo.required' => 'Debe ingresar el logo del formulario',
            'logo.image' => 'El logo debe ser una imagen',
            'logo.mimes' => 'El formato del logo debe ser jpg, jpeg, png o gif',
            'logo.max' => 'El logo no puede superar los 2MB',
            'fondo.image' => 'El fondo debe ser una imagen',
            'fondo.mimes' => 'El formato del fondo debe ser jpg, jpeg, png o gif',
            'fondo.max' => 'El fondo no puede superar los 4MB',
            'color_fondo.required' => 'Debe ingresar el color de fondo',
            'color_texto.required' => 'Debe ingresar el color de letra del formulario',
            'color_subtitulo.required' => 'Debe ingresar el color del subtitulo',
            'color_titulo.required' => 'Debe ingresar el color del titulo',
            'nombre.required' => 'Debe ingresar el nombre del tipo de formulario',
            'slug.required' => 'Debe ingresar la URL del formulario',
            'descripcion.required' => 'Debe ingresar la descripcion del formulario',
            'orientacion_impresion.required' => 'Debe seleccionar la orientacion de impresion',
            'tipo.required' => 'Debe seleccionar el tipo de formulario',
            'descripcion_campo_obligatorio.required' => 'Debe ingresar la descripcion aclarando la marca de los campos obligatorios',
            'mensaje_de_llenado_formulario.required' => 'Debe ingresar el mensaje que se mostrara en la pantalla de llenado del formulario',
            'mensaje_de_formulario_deshabilitado.required' => 'Debe ingresar el mensaje que se mostrará cuando se haya deshabilitado el formulario deshabilitado',
        ];
    }
}
