<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Symfony\Component\HttpFoundation\Response;

class ValidateRutaEnlace
{
    public function handle($request, Closure $next)
    {
        // Obtener las rutas permitidas desde la sesión
        $rutasPermitidas = Session::get('rutasPermitidas', []); // Por defecto, un array vacío

        // Verificar si la ruta actual está en las permitidas
        if (!in_array($request->route()->getName(), $rutasPermitidas)) {
            abort(403, 'No tienes permiso para acceder a esta página.');
        }

        return $next($request);
    }
}
