<?php

namespace App\Http\Controllers;

use App\Models\User;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SsoAutenticacionSeguridadController extends Controller
{
    public function autenticacion(Request $request){
        //dd($request->all());
        try {
            // Captura el token desde la query string
            $token = $request->query('tt');
            // Dividir el token en sus tres partes
            list($header, $payload, $signature) = explode('.', $token);

            // Decodificar el payload (sin verificar la firma)
            $datos = json_decode(base64_decode($payload), true);
            //dd($datos);
            // if (!$token) {
            //     return response()->json(['error' => 'Token no proporcionado'], 400);
            // }

            // // Verificar y decodificar el token
         
            //Registrar o autenticar al usuario en Laravel
            $user = User::firstOrCreate([
                'username' => $datos['Loguin']
            ], [
                'name' => $datos['sub'],
                'idsegUsuario' => $datos['uid'],
                'idsegPerfil' => $datos['IdPerfil'],
                'nombrePerfil' => $datos['Perfil'],
                'password' => bcrypt('password_predeterminado')
            ]);

            // Loguear al usuario
            session(['auth_token' => $user['jwToken']]);
            session(['idsegPerfil' => $user['idsegPerfil']]);
            
            Auth::login($user);

            return redirect()->route('home')->with('success', 'Inicio de sesión exitoso');
        } catch (\Exception $e) {
            return response()->json(['error' => 'Token inválido o expirado', 'message' => $e->getMessage()], 400);
        }
    }
}
