<?php

namespace App\Http\Controllers;


use App\Models\User;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use RealRashid\SweetAlert\Facades\Alert;
use Spatie\Permission\Models\Permission;

class RoleController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $roles=Role::where('id','>',1)->get();
        return view('admin.roles.index',compact('roles'));
    }

    public function create()
    {
        $permissions=Permission::get();
        $grupos=Permission::select('grupo')->orderBy('grupo','asc')->distinct()->get();
        $role= new Role();
        return view('admin.roles.create',compact('permissions','role','grupos'));
    }
    public function store(Request $request)
    {
        $permissions = $request->get('permissions', []);
        
        $role=Role::create(['name'=>$request->name,'descripcion'=>$request->descripcion]);
        $permissions = $request->get('permissions', []);
        // Verifica que no esté vacío y que contenga valores válidos
        $validPermissions = Permission::whereIn('id', $permissions)->pluck('name')->toArray();

        //actualice los permisos
        $role->syncPermissions($validPermissions);
        
        Alert::success('Rol registrado correctamente!');
        return redirect()->route('roles.index');

    }

    public function show(Role $role)
    {
        $permissions=$role->permissions;
        return view('admin.roles.show',compact('role','permissions'));
    }

    public function edit(Role $role)
    {
        $permissions=Permission::get();
        $grupos=Permission::select('grupo')->orderBy('grupo','asc')->distinct()->get();
        return view('admin.roles.edit',compact('role','permissions','grupos'));
    }
    public function update(Request $request, Role $role)
    {
        //actualice el rol
        $role->update($request->all());

        //actualice los permisos
        $role->permissions()->sync($request->get('permissions'));

        Alert::success('Rol actualizado correctamente!');
        return redirect()->route('roles.index');
    }

    // Ejecutar esto como un comando programado o manualmente según sea necesario
    public function disableUsersWithoutRoles()
    {
        // Obtener todos los roles activos
        $activeRoles = Role::pluck('name')->toArray();

        // Obtener usuarios que no tienen roles activos
        $usersToDisable = User::whereDoesntHave('roles', function ($query) use ($activeRoles) {
            $query->whereIn('name', $activeRoles);
        })->get();

        // Deshabilitar usuarios
        foreach ($usersToDisable as $user) {
            $user->delete();
        }

        return  $usersToDisable->count();
    }

    public function destroy(Role $role)
    {
        $role->delete();
        $usuarios = $this->disableUsersWithoutRoles();
        Alert::success('Rol eliminado correctamente y se deshabilitaron '.$usuarios.' usuarios asociados!');
        return redirect()->route('roles.index');
    }
}
