<?php

namespace App\Http\Controllers;

use App\Models\ParItem;
use App\Models\Seccion;
use App\Models\ParPlanta;
use App\Models\ParEmpresa;
use Illuminate\Http\Request;
use App\Models\ParUnidadmedida;
use Illuminate\Validation\Rule;
use App\Models\ParTipoformulario;
use Illuminate\Support\Facades\DB;
use Mews\Purifier\Facades\Purifier;
use App\Models\RepFormularioseccion;
use Illuminate\Support\Facades\Auth;
use App\Models\RepFormulariocontenido;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Validator;

class RepFormularioseccionController extends Controller
{
    public function index($activo_id = null){
        $empresas=ParEmpresa::where('eliminado',false)->get();
        $tipo_formulario=ParTipoformulario::where('eliminado',false)->orderBy('idpar_tipoformulario','asc')->get();
        $items=ParItem::where('eliminado',false)->get(); 
        $unidades=ParUnidadmedida::where('eliminado',false)->get();
        $secciones=RepFormularioseccion::where('eliminado',false)->orderBy('idpar_tipoformulario','asc')->orderBy('orden','asc')->with(['contenido' => function($query){$query->orderBy('idpar_itemgrupo','asc');},'contenido.item'])->get();
        $formularios_secciones=RepFormularioseccion::where('eliminado',false)->select('idpar_tipoformulario')->orderBy('idpar_tipoformulario','asc')->distinct()->with(['formulario' => function($query){ $query->where('eliminado',false); }])->get();
    
        return view('secciones.index',compact('empresas','tipo_formulario','items','unidades','secciones','formularios_secciones','activo_id'));
    }

    public function create()
    {
        $empresas=ParEmpresa::where('eliminado',false)->get();
        $tipo_formulario=ParTipoformulario::where('eliminado',false)->get();
        $items=ParItem::where('eliminado',false)->get(); 
        $unidades=ParUnidadmedida::where('eliminado',false)->get();
        $secciones=RepFormularioseccion::where('eliminado',false)->orderBy('idpar_tipoformulario','asc')->orderBy('orden','asc')->with(['contenido','contenido.item'])->get();
        return view('secciones.create',compact('empresas','tipo_formulario','items','unidades','secciones'));
    }

    public function orden_seccion(Request $request){
        $formulario=$request->idpar_tipoformulario;
        $numero=RepFormularioseccion::where('idpar_tipoformulario',$formulario)->orderBy('orden','desc')->first();
        if(!isset($numero->orden)) {
            $incremento=1;
        }else{
            $incremento=intval($numero->orden) + 1;
        }
        return response()->json($incremento);
    }

    public function store(Request $request)
    {
        $mensaje='';
        $request->validate(
            [
                'idpar_tipoformulario' => 'required',
                'orden' => 'required',
                'nombre' => 'required',
                'tipo' => 'required',
            ],
            [
                'nombre.required' => 'Debe ingresar el nombre de la sección.',
                'orden.required' => 'Debe ingresar la posición de la sección dentro el formulario.',
                'idpar_tipoformulario.required' => 'Debe seleccionar un tipo de formulario.',
                'tipo.required' =>'Debe seleccionar el tipo de contenido que tiene la sección.',
            ]
        );
        if($request->idrep_formularioseccion == null ){
            $seccion=new RepFormularioseccion();
            $seccion->usuario_creacion=Auth::user()->username;
            $seccion->fecha_creacion=now();
            $seccion->tipo = $request->tipo;
            $mensaje='Creada';
        }else{
            $registrosSeccion=DB::table('rep_formularioplanillaregistro as reg')
            ->join('rep_formulariocontenido as cont','cont.idrep_formulariocontenido','=','reg.idrep_formulariocontenido')
            ->join('rep_formularioseccion as sec','sec.idrep_formularioseccion','=','cont.idrep_formularioseccion')
            ->where('sec.idrep_formularioseccion',$request->idrep_formularioseccion)
            ->count();
            $seccion=RepFormularioseccion::find($request->idrep_formularioseccion);
            if($registrosSeccion == 0){
                $seccion->tipo=$request->tipo;
            }
            else{
                if($seccion->tipo != $request->tipo){
                    Alert::error('No se puede cambiar el tipo de contenido porque ya existen registros del formulario en la sección que desea cambiar.');
                    $ultimo_activo=ParTipoformulario::find($seccion->idpar_tipoformulario);
                    return redirect()->route('formularios.index',[$ultimo_activo->idpar_tipoformulario]);
                }
            }
            
            $mensaje='Actualizada';
        }
        $seccion->idpar_tipoformulario=$request->idpar_tipoformulario;
        $seccion->nombre=$request->nombre;
        $seccion->orden=$request->orden;
        $seccion->save();

        Alert::success('Sección '.$mensaje.' Correctamente!');
        $ultimo_activo=ParTipoformulario::find($seccion->idpar_tipoformulario);

        return redirect()->route('formularios.index',[$ultimo_activo->idpar_tipoformulario]);
    }

    public function item_store(Request $request)
    {
        $seccion=RepFormularioseccion::find($request->id_seccion);
        $formulario=ParTipoformulario::find($seccion->idpar_tipoformulario);
        
        $mensaje='';

        Validator::make($request->all(), [
            'nombre_item' => [Rule::requiredIf($request->itemSelect == null),'max:255'],
            'tipo_campo' => 'required',
            'items_lista' => Rule::requiredIf($request->tipo_campo=='select'),
            'orden_item' => 'required',
            'obligatorio' => 'required',
            
        ],[
            'nombre_item.required' => 'Debe ingresar el nombre de la variable.',
            'nombre.max' => 'La nombre no puede superar los 255 caracteres.',
            'tipo_campo.required' => 'Debe indicar que tipo de valor se guardara en el campo',
            'items_lista.required' => 'Debe ingresar los items que se mostraran en el listado, cada valor separar por ";"',
            'orden_item.required' => 'Debe ingresar un número que marca la posición del campo dentro el formulario',
            'obligatorio.required' => 'Debe indicar si el campo es registro obligatorio o no.'
        ])->validateWithBag('errorItem');

        if($request->itemSelect != null){
            $item = ParItem::find($request->itemSelect);
        }
        else{
            if($request->id_item != null){
                $item = ParItem::find($request->id_item);
                $mensaje='Campo actualizado correctamente';
            }
            else{
                $item=new ParItem();
                $mensaje='Campo creado correctamente';
            }
            
            $item->nombre=$request->nombre_item;
            $item->save();
        }
        if($request->id_contenido != null){
            $cuerpo=RepFormulariocontenido::find($request->id_contenido);
            $cuerpo->usuario_modificacion=Auth::user()->name;
            $cuerpo->fecha_modificacion=now();
        }
        else{
            $cuerpo=new RepFormulariocontenido();
            $cuerpo->usuario_creacion=Auth::user()->name;
            $cuerpo->fecha_creacion=now();
            $cuerpo->usuario_modificacion=Auth::user()->name;
            $cuerpo->fecha_modificacion=now();
        }
        
        $cuerpo->idpar_item=$item->idpar_item;
        $cuerpo->idpar_unidadmedida=$request->id_unidad_medida;
        $cuerpo->idrep_formularioseccion=$request->id_seccion;
        $cuerpo->tipo_campo=$request->tipo_campo;
        $cuerpo->orden_item=$request->orden_item;
        $cuerpo->items_lista=$request->items_lista;
        $cuerpo->valor_predeterminado=Purifier::clean($request->valor_predeterminado);
        //$cuerpo->predeterminado=$request->predeterminado;
        $cuerpo->obligatorio=$request->obligatorio;
        //dd($request->unico,$cuerpo);
        $cuerpo->unico=$request->unico;
        $cuerpo->ancho_campo=$request->ancho_campo;
        $cuerpo->save();
        
        Alert::success($mensaje);
        $seccion=RepFormularioseccion::find($request->id_seccion);
        $ultimo_activo=ParTipoformulario::find($seccion->idpar_tipoformulario);

        return redirect()->route('formularios.index',[$ultimo_activo->idpar_tipoformulario]);

    }
    
    public function campos_seccion(Request $request){
        $campos=RepFormulariocontenido::join('par_item as p','p.idpar_item','=','rep_formulariocontenido.idpar_item')
        ->join('rep_formularioseccion as sec','sec.idrep_formularioseccion','=','rep_formulariocontenido.idrep_formularioseccion')
        ->where('sec.idpar_tipoformulario',$request->idform)
        ->where('rep_formulariocontenido.eliminado',false)
        ->whereIn('tipo_campo',['decimal','number'])
        ->select('idrep_formulariocontenido','p.nombre')->get();

        return response()->json($campos);
    }
    public function item_calculo_store(Request $request){
        //dd($request->all());
        Validator::make($request->all(),[
            'formula' => ['required', 'string', function ($attribute, $value, $fail) {
                // Regex para identificar campos (e.g., c1, c2)
                if (!preg_match_all('/c\d+/', $value, $matches)) {
                    $fail("La fórmula contiene referencias a campos inválidos.");
                }
    
                // Validar paréntesis balanceados
                $balance = 0;
                foreach (str_split($value) as $char) {
                    if ($char === '(') $balance++;
                    if ($char === ')') $balance--;
                    if ($balance < 0) $fail("Los paréntesis no están balanceados en la fórmula.");
                }
                if ($balance !== 0) $fail("Los paréntesis no están balanceados en la fórmula.");
            }],'ordenItem_calculo' => 'required','nombreItem_calculo' => 'required',
        ],[
            'formula.required' => 'Debe ingresar la formula de calculo para el campo.',
            'ordenItem_calculo.required' => 'Debe ingresar la posición del campo.',
            'nombreItem_calculo.required' => 'Debe ingresar el nombre del campo.'
        ])->validateWithBag('errorItemCalculo');;
    
        // Extraer IDs de campos de la fórmula
        preg_match_all('/c(\d+)/', $request->formula, $matches);
        $ids = $matches[1];
    
        // Verificar que los campos existen en la base de datos
         $camposExistentes = RepFormulariocontenido::whereIn('idrep_formulariocontenido', $ids)->pluck('idrep_formulariocontenido')->toArray();
        //dd($camposExistentes,$ids);
        if (count($ids) !== count($camposExistentes)) {
            Alert::error('Error', 'Algunos campos referenciados no existen en la base de datos.');
            return back();
        }
    
        if($request->idcontenido_calculo != null){
            $cuerpo=RepFormulariocontenido::find($request->idcontenido_calculo);
            $cuerpo->usuario_modificacion=Auth::user()->name;
            $cuerpo->fecha_modificacion=now();
        }
        else{
            $cuerpo=new RepFormulariocontenido();
            $cuerpo->usuario_creacion=Auth::user()->name;
            $cuerpo->fecha_creacion=now();
        }
        if($request->iditem_calculo != null){
            $item=ParItem::find($request->iditem_calculo);
            if($item->nombre != $request->nombreItem_calculo){
                $item->nombre = $request->nombreItem_calculo;
                $item->save();
            }
        }
        else{
            $item=new ParItem();
            $item->nombre=$request->nombreItem_calculo;
            $item->save();
        }
        $cuerpo->idpar_item=$item->idpar_item;
        $cuerpo->idrep_formularioseccion=$request->idsec_calculo;
        $cuerpo->tipo_campo='calculo';
        $cuerpo->item_formula=$request->formula;
        $cuerpo->orden_item=$request->ordenItem_calculo;
        $cuerpo->save();
        
        $seccion=RepFormularioseccion::find($request->idsec_calculo);
        $ultimo_activo=ParTipoformulario::find($seccion->idpar_tipoformulario);
        
        Alert::success('Campo de tipo calculo registrado correctamente!!!');

        return redirect()->route('formularios.index',[$ultimo_activo->idpar_tipoformulario]);
    }

    public function destroy(RepFormularioseccion $repFormularioseccion)
    {
        DB::table('rep_formulariocontenido')->where('idrep_formularioseccion',$repFormularioseccion->idrep_formularioseccion)->update(['eliminado'=>true]);
        
        $repFormularioseccion->eliminado=true;
        $repFormularioseccion->usuario_modificacion=Auth::user()->name;
        $repFormularioseccion->fecha_modificacion=now();
        $repFormularioseccion->save();
        $ultimo_activo=ParTipoformulario::find($repFormularioseccion->idpar_tipoformulario);
        Alert::success('Seccion Eliminada Correctamente!');
        return redirect()->route('formularios.index',[$ultimo_activo->idpar_tipoformulario]);
    }
}
