<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\ParItem;
use App\Models\DatosRRHH;
use App\Models\ParEmpresa;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Models\ParTipoformulario;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\URL;
use App\Models\RepFormularioseccion;
use Illuminate\Support\Facades\Auth;
use App\Models\RepFormulariocontenido;
use App\Exports\RegistrosDosHojasExport;
use RealRashid\SweetAlert\Facades\Alert;
use App\Models\RepFormularioplanilladato;
use Illuminate\Support\Facades\Validator;
use Barryvdh\DomPDF\Facade\Pdf as FacadePdf;
use App\Models\RepFormularioplanillaregistro;
use Symfony\Component\HttpFoundation\BinaryFileResponse;

class RepFormularioplanilladatoController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(ParTipoformulario $parTipoformulario)
    {
        $secciones=DB::select("
        SELECT sec.nombre as seccion, item.nombre as item, cont.idrep_formulariocontenido as cont,sec.tipo
        FROM rep_formularioseccion as sec INNER JOIN rep_formulariocontenido cont on cont.idrep_formularioseccion=sec.idrep_formularioseccion
        INNER JOIN par_item as item on item.idpar_item=cont.idpar_item
        where sec.eliminado is false and sec.idpar_tipoformulario=$parTipoformulario->idpar_tipoformulario and cont.eliminado is FALSE and item.eliminado is false order by cont
        ");

       // 1. Consulta PostgreSQL
        $registros = DB::table('rep_formularioplanilladato as pla')
        ->join('rep_formularioplanillaregistro as reg', 'pla.idrep_formularioplanilladato', '=', 'reg.idrep_formularioplanilladato')
        ->join('rep_formulariocontenido as cont', 'cont.idrep_formulariocontenido', '=', 'reg.idrep_formulariocontenido')
        ->where('pla.eliminado', false)
        ->where('reg.eliminado', false)
        ->where('cont.eliminado', false)
        ->where('pla.idpar_tipoformulario', $parTipoformulario->idpar_tipoformulario)
        ->select(
            'pla.idrep_formularioplanilladato',
            'pla.fecha_registro_formulario', 
            'reg.idrep_formulariocontenido', 
            'quien_registro',
            'pla.observacion',
            'reg.valor',
            'pla.estado',
            'cont.tipo_campo','pla.fecha_creacion'
        )
        ->orderByRaw('DATE(pla.fecha_creacion) DESC')
        ->orderBy('pla.idrep_formularioplanilladato')
        ->orderBy('cont.orden_item', 'asc')
        ->get();

        // 2. Obtener CIs únicos y normalizarlos (trim, upper por si tienen letras, etc.)
        $cis = $registros
        ->filter(fn($r) => $r->tipo_campo === 'CI' && !is_null($r->valor))
        ->map(fn($r) => trim(strtoupper($r->valor)))
        ->unique()
        ->toArray();

        // 3. Consultar datos Oracle con CI normalizado (usa whereRaw si necesitas aplicar upper en Oracle)
        $personas = DatosRRHH::whereIn(DB::raw('UPPER(TRIM(ci))'), $cis)
        ->get()
        ->keyBy(fn($p) => strtoupper(trim($p->ci))); // normaliza también aquí

        // 4. Combinar datos
        $registros = $registros->map(function ($registro) use ($personas) {
        if ($registro->tipo_campo === 'CI') {
            
            $ci_normalizado = strtoupper(trim($registro->valor));
            // dd([
            //     'CI normalizado buscado' => $ci_normalizado,
            //     'Claves disponibles en personas' => $personas->keys()
            // ]);
            if ($personas->has($ci_normalizado)) {
                $persona = $personas[$ci_normalizado];
                // dd($persona);
                $registro->persona_nombres = $persona->nombre;
                $registro->persona_unidad = $persona->unidad;
                $registro->persona_cargo = $persona->cargo;
                $registro->persona_gerencia = $persona->area;
            }
        }
        return $registro;
        });

        // Agrupar manualmente los registros
        $datosVista = [];
        $registrosAgrupados = [];

        foreach ($registros as $registro) {
            $idPlanilla = $registro->idrep_formularioplanilladato;
            
            // Agrupa los registros por ID de planilla
            if (!isset($registrosAgrupados[$idPlanilla])) {
                $registrosAgrupados[$idPlanilla] = [
                    'idrep_formularioplanilladato' => $idPlanilla,
                    'fecha_registro_formulario' => $registro->fecha_creacion,
                    'quien_registro' => $registro->quien_registro,
                    'observacion' => $registro->observacion,
                    'estado' => $registro->estado,
                    'nombre' => $registro->persona_nombres ?? null,
                    'unidad' => $registro->persona_unidad ?? null,
                    'cargo' => $registro->persona_cargo ?? null,
                    'gerencia' => $registro->persona_gerencia ?? null,
                    'valores' => []
                ];
            }

            // Almacena los valores por item, incluyendo el tipo de campo
            $registrosAgrupados[$idPlanilla]['valores'][$registro->idrep_formulariocontenido] = $registro->valor;
            $registrosAgrupados[$idPlanilla]['tipos'][$registro->idrep_formulariocontenido] = $registro->tipo_campo;
        }

        // Convierte a array para la vista
        $datosVista = array_values($registrosAgrupados);
        // dd($datosVista);
        return view('registro.index', [
            'parTipoformulario' => $parTipoformulario,
            'registros' => $datosVista,
            'secciones' => $secciones  // Tus secciones existentes
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $encuesta=1;
        $repFormularioplanilladato=new RepFormularioplanilladato();
        $usuarios=User::all();
        $secciones=RepFormularioseccion::where('eliminado',false)
        ->where('idpar_tipoformulario',$encuesta)
        ->with(['contenido' => function ($query) {
            $query->orderBy('orden_item','asc');
        }])
        ->get();
        $parTipoformulario=ParTipoformulario::find($encuesta);
        $imagen=public_path() . '/img/'.$parTipoformulario->logo;

        $url = URL::to("/ext/{$parTipoformulario->slug}");

        return view('welcome',compact('parTipoformulario','usuarios','repFormularioplanilladato','secciones','imagen','url'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //dd($request->all());
        $items = $request->input('items', []); // Obtener los ítems enviados desde el formulario

        foreach ($items as $id => $value) {
            $item = RepFormulariocontenido::find($id);
            //dd($item); // Obtén el ítem desde la base de datos
            $dato_item=ParItem::find($item->idpar_item);
            //dd($dato_item);
            if($item->obligatorio == true) {
                if ($item->unico == true) {
                //dd($item,'obligatorio unico');
                    // Validar unicidad dentro del tipo de item
                    $rules["items.$id"] = [
                        'string',
                        Rule::unique('rep_formularioplanillaregistro', 'valor')
                            ->where(function ($query) use ($item) {
                                return $query->where('idrep_formulariocontenido', $item->idpar_item);
                            })
                    ];
        
                    $messages["items.$id.string"] = "El valor del $dato_item->nombre debe ser texto.";
                    $messages["items.$id.unique"] = "El valor del $dato_item->nombre ya ha sido registrado.";
                }
                else{

                    if ($item && $item->idpar_unidadmedida) {
                        // Si tiene unidad de medida, debe ser numérico
                        $rules["items.$id"] = ['required', 'numeric'];
                        $messages["items.$id.numeric"] = "El valor del $dato_item->nombre debe ser numérico.";
                    } else {
                        // Si no tiene unidad de medida, debe ser texto
                        $rules["items.$id"] = ['required'];
                        $messages["items.$id.string"] = "El valor del  $dato_item->nombre debe ser texto.";
                    }
                    $messages["items.$id.required"] = "Debe ingresar un valor para el $dato_item->nombre.";
                }
            }
            else{
                if ($item->unico == true) {
                //dd('unico');
                    // Validar unicidad dentro del tipo de item
                    $rules["items.$id"] = [
                        'string',
                        Rule::unique('rep_formularioplanillaregistro', 'valor')
                            ->where(function ($query) use ($item) {
                                return $query->where('idpar_item', $item->idpar_item);
                            })
                    ];
        
                    $messages["items.$id.unique"] = "El valor del $dato_item->nombre ya ha sido registrado en este tipo de encuesta.";
                }
            }
        }

        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        
        $datosRegistro= new RepFormularioplanilladato();
        $datosRegistro->idpar_tipoformulario = $request->idpar_tipoformulario;
        $datosRegistro->fecha_registro_formulario = $request->fecha_registro_formulario;
        $datosRegistro->quien_registro = 'invitado';
        $datosRegistro->usuario_creacion='invitado';
        $datosRegistro->fecha_creacion=now();
        $datosRegistro->usuario_modificacion='invitado';
        $datosRegistro->fecha_modificacion=now();
        $datosRegistro->save();
        
        $files = $request->file('items', []);
        foreach ($files as $id => $uploadedFiles) {
            if (!is_array($uploadedFiles)) {
                $uploadedFiles = [$uploadedFiles];
            }

            $filePaths = []; // Lista para guardar rutas de archivos

            foreach ($uploadedFiles as $file) {
        
                if ($file->isValid()) {
                    $mimeType = $file->getMimeType();
                    
                    $fileName = time() . '_' . $file->getClientOriginalName();
                    $file->move(public_path('adjuntos'), $fileName);
                    $filePaths[] = $fileName;
                } else {
                    return back()->withErrors(['items' => 'Uno o más archivos no son válidos.']);
                }
            }
        
            if (!empty($filePaths)) {
                DB::table('rep_formularioplanillaregistro')->updateOrInsert(
                    [
                        'idrep_formularioplanilladato' => $datosRegistro->idrep_formularioplanilladato,
                        'idrep_formulariocontenido' => $id
                    ],
                    [
                        'valor' => implode(';', $filePaths),
                        'usuario_creacion' => 'invitado',
                        'usuario_modificacion' => 'invitado',
                        'fecha_creacion' => now(),
                        'fecha_modificacion' => now(),
                    ]
                );
            }
        }
        // Iterar sobre los items y guardarlos en la base de datos
        foreach ($request['items'] as $id_item => $value) {
            // Convertir array a string con ; si es necesario
            $valorFinal = is_array($value) ? implode(';', $value) : $value;
        
            DB::table('rep_formularioplanillaregistro')->insert([
                'idrep_formularioplanilladato' => $datosRegistro->idrep_formularioplanilladato,
                'idrep_formulariocontenido' => $id_item,
                'valor' => $valorFinal,
                'usuario_creacion' => 'invitado',
                'usuario_modificacion' => 'invitado',
                'fecha_creacion' => now(),
                'fecha_modificacion' => now(),
            ]);
        }

        $conTabla=RepFormularioseccion::where('eliminado',false)->where('idpar_tipoformulario', $request->idpar_tipoformulario)->where('tipo','tabla')->count();
        if($conTabla > 0){
            $seccionesTabla=RepFormularioseccion::where('eliminado',false)->where('idpar_tipoformulario', $request->idpar_tipoformulario)->where('tipo','tabla')->first();
            return redirect()->route('registros.tabla',[$datosRegistro->idrep_formularioplanilladato,$seccionesTabla->idrep_formularioseccion]);
        }
        Alert::success('Datos registrados correctamente!!');
        $parTipoformulario=ParTipoformulario::find($request->idpar_tipoformulario);
        return redirect()->route('formulario_registrado.index',[$parTipoformulario->slug]);
    }

    public function formulario_registrado($slug){
        $parTipoformulario=ParTipoformulario::where('slug',$slug)->first();
        return view('planilla_registrada',compact('parTipoformulario'));
    }

    public function create_tabla(RepFormularioplanilladato $repFormularioplanilladato, RepFormularioseccion $repFormularioseccion){
        $secciones=RepFormularioseccion::where('eliminado',false)
        ->where('idpar_tipoformulario',$repFormularioplanilladato->idpar_tipoformulario)
        ->where('tipo','tabla')->where('idrep_formularioseccion',$repFormularioseccion->idrep_formularioseccion)
        ->with(['contenido' => function ($query) {
            $query->orderBy('orden_item','asc');
        },'contenido.item'])
        ->get();

        $cabecera=DB::select("
        SELECT sec.nombre as seccion, item.nombre as item, cont.idrep_formulariocontenido as cont,cont.ancho_campo
        FROM rep_formularioseccion as sec INNER JOIN rep_formulariocontenido cont on cont.idrep_formularioseccion=sec.idrep_formularioseccion
        INNER JOIN par_item as item on item.idpar_item=cont.idpar_item
        where sec.tipo='tabla' and sec.idrep_formularioseccion = $repFormularioseccion->idrep_formularioseccion and sec.eliminado is false and sec.idpar_tipoformulario=$repFormularioplanilladato->idpar_tipoformulario and cont.eliminado is FALSE and item.eliminado is false order by cont.orden_item
        ");

        $nombres=DatosRRHH::distinct('nombre')->pluck('nombre');
        $cargos=DatosRRHH::distinct('cargo')->pluck('cargo');

        $registros=DB::table('rep_formularioplanilladato as pla')
        ->join('rep_formularioplanillaregistro as reg', 'pla.idrep_formularioplanilladato', '=', 'reg.idrep_formularioplanilladato')
        ->join('rep_formulariocontenido as cont', 'cont.idrep_formulariocontenido', '=', 'reg.idrep_formulariocontenido')
        ->join('rep_formularioseccion as sec','sec.idrep_formularioseccion','=','cont.idrep_formularioseccion')
        ->where('pla.eliminado', false)
        ->where('reg.eliminado', false)
        ->where('cont.eliminado', false)
        ->where('pla.idrep_formularioplanilladato',$repFormularioplanilladato->idrep_formularioplanilladato)
        ->where('sec.idrep_formularioseccion',$repFormularioseccion->idrep_formularioseccion)
        ->select(
            'pla.idrep_formularioplanilladato',
            'reg.idrep_formulariocontenido', 'quien_registro',
            'reg.valor','reg.estado','sec.idrep_formularioseccion','nro_item','ancho_campo'
        )->orderBy('cont.orden_item','asc')->orderBy('nro_item','asc')->get();

        $datosVista = [];
        $registrosAgrupados = [];
        foreach ($registros as $registro) {
            $idPlanilla = $registro->nro_item;
            
            // Agrupa los registros por ID de planilla
            if (!isset($registrosAgrupados[$idPlanilla])) {
                $registrosAgrupados[$idPlanilla] = [
                    'idrep_formularioplanilladato' => $idPlanilla,
                    'quien_registro' => $registro->quien_registro,
                    'estado' => $registro->estado,
                    'nro_item' => $registro->nro_item,
                    'idPlanilla' => $registro->idrep_formularioplanilladato,
                    'seccion' => $registro->idrep_formularioseccion,
                    'ancho' => $registro->ancho_campo,
                    'valores' => []
                ];
            }

            // Almacena los valores por item
            $registrosAgrupados[$idPlanilla]['valores'][$registro->idrep_formulariocontenido] = $registro->valor;
        }

        $datosVista = array_values($registrosAgrupados);
        $parTipoformulario=ParTipoformulario::find($repFormularioplanilladato->idpar_tipoformulario);
        return view('registro.create_tabla',compact('parTipoformulario','repFormularioplanilladato','secciones','datosVista','cabecera','nombres','cargos'));
    }

    public function store_tabla(Request $request)
    {
        $nro_items=DB::table('rep_formularioplanilladato as pla')
        ->join('rep_formularioplanillaregistro as reg', 'pla.idrep_formularioplanilladato', '=', 'reg.idrep_formularioplanilladato')
        ->join('rep_formulariocontenido as cont', 'cont.idrep_formulariocontenido', '=', 'reg.idrep_formulariocontenido')
        ->join('rep_formularioseccion as sec','sec.idrep_formularioseccion','=','cont.idrep_formularioseccion')
        ->where('pla.eliminado', false)
        ->where('reg.eliminado', false)
        ->where('cont.eliminado', false)
        ->where('pla.idrep_formularioplanilladato',$request->idrep_formularioplanilladato)
        ->where('sec.idrep_formularioseccion',$request->id_seccion)->distinct('nro_item')->count();

        $codigo=$nro_items+1;
        foreach ($request['items'] as $id_item => $value) {
            // Almacena cada item con su valor
            DB::table('rep_formularioplanillaregistro')->insert([
                'idrep_formularioplanilladato'=>$request->idrep_formularioplanilladato,
                'idrep_formulariocontenido' => $id_item,
                'valor' => $value ,
                'usuario_creacion' => Auth::user()->username,
                'usuario_modificacion' => Auth::user()->username,
                'fecha_creacion' => now(),
                'fecha_modificacion' => now(),
                'nro_item' => $codigo
            ]);
        }

        return redirect()->route('registros.tabla',[$request->idrep_formularioplanilladato,$request->id_seccion]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ParTipoformulario $parTipoformulario, RepFormularioplanilladato $repFormularioplanilladato)
    {
        $usuarios=User::all();            
        $secciones=RepFormularioseccion::where('eliminado',false)
        ->where('idpar_tipoformulario',$parTipoformulario->idpar_tipoformulario)
        ->with(['contenido' => function ($query) {
            $query->orderBy('orden_item','asc');
        }])->get();

        //dd($repFormularioplanilladato->registros);
        return view('registro.edit',compact('parTipoformulario','usuarios','repFormularioplanilladato','secciones'));
    }

    public function aprobar(RepFormularioplanilladato $repFormularioplanilladato){
        $registros=RepFormularioplanillaregistro::where('idrep_formularioplanilladato',$repFormularioplanilladato->idrep_formularioplanilladato)->get();
        foreach ($registros as $item) {
            $item->estado=true;
            $item->usuario_modificacion=Auth::user()->username;
            $item->fecha_modificacion=now();
            $item->save();
        }

        $repFormularioplanilladato->estado=true;
        $repFormularioplanilladato->usuario_modificacion=Auth::user()->username;
        $repFormularioplanilladato->fecha_modificacion=now();
        $repFormularioplanilladato->save();

        return redirect()->route('planillas.index',[$repFormularioplanilladato->idpar_tipoformulario]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, RepFormularioplanilladato $repFormularioplanilladato)
    {
        
        $items = $request->input('items', []); // Obtener los ítems enviados desde el formulario
        $rules = [
            'quien_registro' => 'required|string',
        ];
    
        $messages = [
            'fecha_registro_formulario.date' => 'La fecha de registro debe ser una fecha válida.',
            'quien_registro.required' => 'El campo "quién registró" es obligatorio.',
        ];

        foreach ($items as $id => $value) {
            $item = RepFormulariocontenido::find($id); // Obtén el ítem desde la base de datos
            $dato_item=ParItem::find($item->idpar_item);
            if($item->obligatorio == true) {
                if ($item && $item->idpar_unidadmedida) {
                    // Si tiene unidad de medida, debe ser numérico
                    $rules["items.$id"] = ['required', 'numeric'];
                    $messages["items.$id.numeric"] = "El valor del ítem $dato_item->nombre debe ser numérico.";
                } else {
                    // Si no tiene unidad de medida, debe ser texto
                    $rules["items.$id"] = ['required', 'string'];
                    $messages["items.$id.string"] = "El valor del ítem  $dato_item->nombre debe ser texto.";
                }
                $messages["items.$id.required"] = "Debe ingresar un valor para el ítem $dato_item->nombre.";
            }
        }

        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        
        $repFormularioplanilladato->idpar_tipoformulario = $request->idpar_tipoformulario;
        $repFormularioplanilladato->fecha_registro_formulario = $request->fecha_registro_formulario;
        $repFormularioplanilladato->quien_registro = $request->quien_registro;
        $repFormularioplanilladato->observacion = $request->observacion;
        $repFormularioplanilladato->usuario_creacion=Auth::user()->name;
        $repFormularioplanilladato->fecha_creacion=now();
        $repFormularioplanilladato->usuario_modificacion=Auth::user()->name;
        $repFormularioplanilladato->fecha_modificacion=now();
        $repFormularioplanilladato->save();

        
        foreach ($items as $id_item => $value) {
            // Almacena cada item con su valor
            $registro=RepFormularioplanillaregistro::where('idrep_formulariocontenido',$id_item)->where('idrep_formularioplanilladato',$repFormularioplanilladato->idrep_formularioplanilladato)->first();
            //dd($registro);
            if($registro){
                $registro->valor=$value;
                $registro->usuario_modificacion=Auth::user()->username;
                $registro->fecha_modificacion=now();
                $registro->save();
            }
            else{
                DB::table('rep_formularioplanillaregistro')->insert([
                    'idrep_formularioplanilladato'=>$repFormularioplanilladato->idrep_formularioplanilladato,
                    'idrep_formulariocontenido' => $id_item,
                    'valor' => $value,
                    'usuario_creacion' => Auth::user()->username,
                    'usuario_modificacion' => Auth::user()->username,
                    'fecha_creacion' => now(),
                    'fecha_modificacion' => now(),
                ]);
            }
        }
        Alert::success('Datos actualizados correctamente!');
        $seccion = RepFormularioseccion::where('idpar_tipoformulario',$repFormularioplanilladato->idpar_tipoformulario)->first();
        //return redirect()->route('registros.tabla',[$repFormularioplanilladato->idrep_formularioplanilladato,$seccion->idrep_formularioseccion]);
        return redirect()->route('planillas.index',[$repFormularioplanilladato->idpar_tipoformulario]);
        //return redirect()->route('planillas.index',[$request->idpar_tipoformulario]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(RepFormularioplanilladato $repFormularioplanilladato)
    {
        //Se elimina primero todos los registros asociados a la planilla creada
        DB::table('rep_formularioplanillaregistro')
        ->where('idrep_formularioplanilladato', $repFormularioplanilladato->idrep_formularioplanilladato)
        ->delete();

        //Se elimina la planilla
        $repFormularioplanilladato->delete();
        
        Alert::success('Registro Eliminado correctamente!');
        
        return redirect()->route('planillas.index',[$repFormularioplanilladato->idpar_tipoformulario]);
    }

    public function exportar_excel(Request $request){
        //dd($request->all());
        $secciones=unserialize(base64_decode($request->secciones));
        $registros=unserialize(base64_decode($request->registros));
        //  dd($registros);
        $parTipoformulario=ParTipoformulario::find($request->parTipoformulario);

        $cabecera=DB::select("
        SELECT sec.nombre as seccion, item.nombre as item, cont.idrep_formulariocontenido as cont
        FROM rep_formularioseccion as sec INNER JOIN rep_formulariocontenido cont on cont.idrep_formularioseccion=sec.idrep_formularioseccion
        INNER JOIN par_item as item on item.idpar_item=cont.idpar_item
        where sec.tipo='tabla' and sec.eliminado is false and sec.idpar_tipoformulario=$request->parTipoformulario and cont.eliminado is FALSE and item.eliminado is false order by cont
        ");

        //dd($cabecera);
        $tabla=DB::table('rep_formularioplanilladato as pla')
        ->join('rep_formularioplanillaregistro as reg', 'pla.idrep_formularioplanilladato', '=', 'reg.idrep_formularioplanilladato')
        ->join('rep_formulariocontenido as cont', 'cont.idrep_formulariocontenido', '=', 'reg.idrep_formulariocontenido')
        ->join('rep_formularioseccion as sec','sec.idrep_formularioseccion','=','cont.idrep_formularioseccion')
        ->where('pla.eliminado', false)
        ->where('reg.eliminado', false)
        ->where('cont.eliminado', false)
        ->where('pla.idpar_tipoformulario',$request->parTipoformulario)
        ->where('sec.tipo','tabla')
        ->select(
            'pla.idrep_formularioplanilladato','pla.idpar_tipoformulario',
            'reg.idrep_formulariocontenido', 'quien_registro',
            'reg.valor','reg.estado','sec.idrep_formularioseccion','nro_item'
        )->orderBy('cont.orden_item','asc')->orderBy('nro_item','asc')->get();
        //dd($tabla);
        $datosVista = [];
        $registrosAgrupados = [];
        foreach ($tabla as $registro) {
            $idPlanilla = $registro->idrep_formularioplanilladato;
            $idItem = $registro->nro_item;
            
            // Agrupa los registros por ID de planilla
            if (!isset($registrosAgrupados[$idPlanilla][$idItem])) {
                $registrosAgrupados[$idPlanilla][$idItem] = [
                    'idrep_formularioplanilladato' => $idPlanilla,
                    'id_planilla' => $registro->idrep_formularioplanilladato,
                    'quien_registro' => $registro->quien_registro,
                    'estado' => $registro->estado,
                    'nro_item' => $registro->nro_item,
                    'valores' => []
                ];
            }

            // Almacena los valores por item
            $registrosAgrupados[$idPlanilla][$idItem]['valores'][$registro->idrep_formulariocontenido] = $registro->valor;
        }

        
        $datosVista = ($registrosAgrupados);
        $texto='Registros_de_'.$parTipoformulario->nombre.'_al_'.date('d-m-Y').'.xlsx';
        $datosVista = ($registrosAgrupados);
        $titulo=str_replace(array("/", "\\", ":", "*", "?", "«", "<", ">", "|"), "-", $texto);
        return (new RegistrosDosHojasExport($secciones,$registros,$parTipoformulario,$datosVista,$cabecera))->download($titulo);
        //return (new RegistrosDosHojasExport($secciones,$registros,$parTipoformulario,$datosVista,$cabecera))->download('registros_formulario_'.$parTipoformulario->nombre.'.xlsx');
    }

    public function exportar_pdf(RepFormularioplanilladato $repFormularioplanilladato){
        $secciones=RepFormularioseccion::where('eliminado',false)
        ->where('idpar_tipoformulario',$repFormularioplanilladato->idpar_tipoformulario)
        ->with(['contenido' => function ($query) {
            $query->orderBy('orden_item','asc');
        }])->get();

        $cabecera=DB::select("
        SELECT sec.nombre as seccion, item.nombre as item, cont.idrep_formulariocontenido as cont, cont.ancho_campo
        FROM rep_formularioseccion as sec INNER JOIN rep_formulariocontenido cont on cont.idrep_formularioseccion=sec.idrep_formularioseccion
        INNER JOIN par_item as item on item.idpar_item=cont.idpar_item
        where sec.tipo='tabla' and sec.eliminado is false and sec.idpar_tipoformulario=$repFormularioplanilladato->idpar_tipoformulario and cont.eliminado is FALSE and item.eliminado is false order by cont.orden_item
        ");


        $registros=DB::table('rep_formularioplanilladato as pla')
        ->join('rep_formularioplanillaregistro as reg', 'pla.idrep_formularioplanilladato', '=', 'reg.idrep_formularioplanilladato')
        ->join('rep_formulariocontenido as cont', 'cont.idrep_formulariocontenido', '=', 'reg.idrep_formulariocontenido')
        ->join('rep_formularioseccion as sec','sec.idrep_formularioseccion','=','cont.idrep_formularioseccion')
        ->where('pla.eliminado', false)
        ->where('reg.eliminado', false)->where('reg.estado', true)
        ->where('cont.eliminado', false)
        ->where('pla.idrep_formularioplanilladato',$repFormularioplanilladato->idrep_formularioplanilladato)
        ->where('sec.tipo','tabla')
        ->select(
            'pla.idrep_formularioplanilladato',
            'reg.idrep_formulariocontenido', 'quien_registro',
            'reg.valor','reg.estado','sec.idrep_formularioseccion','nro_item','cont.tipo_campo','pla.fecha_creacion'
        )->orderBy('cont.orden_item','asc')->orderBy('nro_item','asc')->get();
        //dd($registros,$cabecera);
        $datosVista = [];
        $registrosAgrupados = [];
        foreach ($registros as $registro) {
            $idPlanilla = $registro->nro_item;
            
            // Agrupa los registros por ID de planilla
            if (!isset($registrosAgrupados[$idPlanilla])) {
                $registrosAgrupados[$idPlanilla] = [
                    'idrep_formularioplanilladato' => $idPlanilla,
                    'fecha_registro_formulario' => $registro->fecha_creacion,
                    'quien_registro' => $registro->quien_registro,
                    'estado' => $registro->estado,
                    'nro_item' => $registro->nro_item,
                    'tipo_campo' => $registro->tipo_campo,
                    'valores' => []
                ];
            }

            // Almacena los valores por item
            $registrosAgrupados[$idPlanilla]['valores'][$registro->idrep_formulariocontenido] = $registro->valor;
        }

        $datosVista = array_values($registrosAgrupados);
        
        $parTipoformulario=ParTipoformulario::find($repFormularioplanilladato->idpar_tipoformulario); 
        $titulo=$parTipoformulario->tipo." ".$parTipoformulario->slug;
        $empresa=ParEmpresa::find(1);
        $imagen=public_path() . '/img/'.$parTipoformulario->logo;
        $estilos=public_path() . '/assets/css/report.css';
        $pdf = FacadePdf::loadView('registro.pdf.planilla',compact('secciones','repFormularioplanilladato','parTipoformulario','cabecera','datosVista','imagen','estilos'));
        $pdf->setPaper('Letter', $parTipoformulario->orientacion_impresion);
        // $pdf->setPaper('Letter', 'portrait');
        return $pdf->stream(Str::ascii($titulo).'.pdf');
    }

    public function destroy_registro(RepFormularioplanilladato $repFormularioplanilladato,$item,RepFormularioseccion $repFormularioseccion){
        
        DB::table('rep_formularioplanillaregistro')
        ->where('idrep_formularioplanilladato', $repFormularioplanilladato->idrep_formularioplanilladato)
        ->where('nro_item',$item)
        ->delete();

        Alert::success('Registro Eliminado correctamente!');

        return redirect()->route('registros.tabla',[$repFormularioplanilladato->idrep_formularioplanilladato,$repFormularioseccion->idrep_formularioseccion]);

    }

    public function formulario_finalizado($slug){
        $parTipoformulario=ParTipoformulario::where('slug',$slug)->first();
        return view('formulario_finalizado',compact('parTipoformulario'));
    }

    public function publicar_formulario($slug){
        $usuarios=User::all();
        //dd(now());
        $parTipoformulario=ParTipoformulario::where('slug',$slug)->first();
        if($parTipoformulario->estado==1 && $parTipoformulario->fecha_inicio <= now() && $parTipoformulario->fecha_fin >= now()){
            $repFormularioplanilladato=new RepFormularioplanilladato();
            $secciones=RepFormularioseccion::where('eliminado',false)
            ->where('idpar_tipoformulario',$parTipoformulario->idpar_tipoformulario)
            ->with(['contenido' => function ($query) {
                $query->orderBy('orden_item','asc');
            }])->orderBy('orden','asc')
            ->get();
            $parTipoformulario=ParTipoformulario::find($parTipoformulario->idpar_tipoformulario);
            $imagen=public_path() . '/img/'.$parTipoformulario->logo;
            $url = URL::to("/ext/{$parTipoformulario->slug}");
            return view('welcome',compact('parTipoformulario','usuarios','repFormularioplanilladato','secciones','imagen','url'));
        }
        else{
            return redirect()->route('formulario_finalizado.index',[$parTipoformulario->slug]);
        }
    }

    public function show(ParTipoformulario $parTipoformulario)
    {
        $usuarios=User::all();
        $repFormularioplanilladato=new RepFormularioplanilladato();
        $secciones=RepFormularioseccion::where('eliminado',false)
        ->where('idpar_tipoformulario',$parTipoformulario->idpar_tipoformulario)
        ->with(['contenido' => function ($query) {
            $query->orderBy('orden_item','asc');
        }])->orderBy('orden','asc')
        ->get();
        // $parTipoformulario=ParTipoformulario::find($parTipoformulario->idpar_tipoformulario);
        $imagen=public_path() . '/img/'.$parTipoformulario->logo;
        $url = URL::to("/ext/{$parTipoformulario->slug}");
        return view('registro.show',compact('parTipoformulario','usuarios','repFormularioplanilladato','secciones','imagen','url'));
    }

    public function ver_adjuntos($adjunto)
    {
        $ruta =public_path().'/adjuntos/'.$adjunto;
        
        if (file_exists($ruta)) {
            $tipo = mime_content_type($ruta);
            
            $respuesta = new BinaryFileResponse($ruta);
            $respuesta->headers->set('Content-Type', $tipo);
            $respuesta->setContentDisposition('inline', $adjunto);
            
            return $respuesta;
        } else {
            // Si el archivo no existe, devolver una respuesta o redirigir con un mensaje
            return response()->json(['error' => 'El archivo no se encuentra disponible'], 404);
        }
        
        return abort(404, 'Documento no encontrados');
    }
}
