<?php

namespace App\Http\Controllers;

use App\Models\ParItem;
use App\Models\Formulario;
use Illuminate\Http\Request;
use App\Models\ParUnidadmedida;
use App\Models\ParTipoformulario;
use Illuminate\Support\Facades\DB;
use App\Models\RepFormularioseccion;
use Illuminate\Support\Facades\Auth;
use App\Models\RepFormulariocontenido;
use RealRashid\SweetAlert\Facades\Alert;

class RepFormulariocontenidoController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(RepFormularioseccion $formulario)
    {
        //dd($request->all());
        $secciones=DB::table('seccion as s')->join('formulario as f','f.id_formulario','=','s.id_formulario')
        ->join('item as i','i.id_item','=','s.id_item')
        ->where('f.id_formulario','=',$formulario->id_formulario)
        ->select('f.id_formulario','s.id_seccion','i.id_item','f.nombre as formulario','s.nombre as seccion','i.nombre as item')
        ->get();
        return response()->json($secciones);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(RepFormularioseccion $formulario)
    {
        $secciones=$formulario->secciones;
        $items=ParItem::where('eliminado',false)->get();
        $unidades=ParUnidadmedida::where('eliminado',false)->get();
        return view('cuerpo_formulario.create',compact('formulario','secciones','items','unidades'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $seccion=new RepFormulariocontenido();
        $seccion->nombre=$request->nombre;
        $seccion->orden=$request->orden;
        $seccion->id_formulario=$request->id_formulario;
        $seccion->usuario_creacion=Auth::user()->name;
        $seccion->fecha_creacion=now();
        $seccion->usuario_modificacion=Auth::user()->name;
        $seccion->fecha_modificacion=now();
        $seccion->save();

        // Validar los datos del formulario
        $validatedData = $request->validate([
            'items' => 'required|array', // Verifica que los items estén presentes
            'items.*' => 'required|numeric', // Cada item puede ser nulo o texto
            'fecha_registro_formulario' =>'required'
        ]);

        // Iterar sobre los items y guardarlos en la base de datos
        foreach ($validatedData['items'] as $id_item => $value) {
            // Almacena cada item con su valor
            DB::table('registro_formulario')->insert([
                'fecha_registro_formulario'=>$request->fecha_registro_formulario,
                'id_item' => $id_item,
                'valor' => $value,
                'usuario_creacion' => Auth::user()->username,
                'usuario_modificacion' => Auth::user()->username,
                'fecha_creacion' => now(),
                'fecha_modificacion' => now(),
            ]);
        }

        $formulario=ParTipoformulario::find($request->id_formulario);

        return redirect()->route('registro.create',compact('formulario'));
    }

    public function destroy(RepFormulariocontenido $repFormulariocontenido)
    {
        //buscar el formulario contenido
        $repFormulariocontenido->eliminado=true;
        $repFormulariocontenido->usuario_modificacion=Auth::user()->name;
        $repFormulariocontenido->fecha_modificacion=now();
        $repFormulariocontenido->save();
        
        Alert::success('Variable Eliminada Correctamente!');

        return redirect()->route('formularios.index');
    }
}
