<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ParTipoformulario;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Role;
use RealRashid\SweetAlert\Facades\Alert;
use Spatie\Permission\Models\Permission;

class PerfilPermisoController extends Controller
{
    public function index()
    {
        $perfiles=Role::all();
        $formularios=ParTipoformulario::where('eliminado',false)->orderBy('idpar_tipoformulario','asc')->get();
        return view('admin.perfiles-permisos.index',compact('perfiles','formularios'));
    }

    public function guardar(Request $request)
    {
        $rolNombre = $request->get('rol');
        $rol = Role::where('name', $rolNombre)->first();

        $data = $request->get('permisos'); // permisos[formulario][accion]
        $rol->syncPermissions([]); // limpia todo

        foreach ($data as $formularioId => $acciones) {
            foreach ($acciones as $accion => $valor) {
                if ($valor) {
                    $permiso = $accion . '_formulario_' . $formularioId;
                    Permission::firstOrCreate(['name' => $permiso]);
                    $rol->givePermissionTo($permiso);
                }
            }
        }
        Alert::success('Permisos del perfil actualizados.');
        return redirect()->back();
    }

    public function obtenerPermisos(Request $request)
    {
        $perfil = $request->get('perfil');

        $permisos = DB::table('roles')
            ->where('name', $perfil)
            ->get();

        return response()->json($permisos);
    }

    public function obtenerPermisosPorRol(Request $request)
    {

        $rolNombre = $request->get('rol');
        $rol = Role::where('name', $rolNombre)->with('permissions')->first();
        // dd($rol->permissions->pluck('name'));
        return response()->json($rol->permissions->pluck('name'));
    }

    public function seedPermisosDesdeFormularios()
    {
        $acciones = ['registrar', 'editar', 'eliminar', 'aprobar','ver'];
        $formularios = ParTipoformulario::where('eliminado',false)->get();
    
        foreach ($formularios as $formulario) {
            foreach ($acciones as $accion) {
                $nombre = $accion . '_formulario_' . $formulario->idpar_tipoformulario;
                Permission::firstOrCreate(['name' => $nombre]);
            }
        }
    
        return 'Permisos generados correctamente desde formularios';
    }
}
