<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ParUnidadmedida;
use Illuminate\Support\Facades\Auth;
use App\Models\RepFormulariocontenido;

class ParUnidadmedidaController extends Controller
{
    public function index()
    {
        $result = ParUnidadmedida::where('eliminado', 0)->get();
        return view('unidades_medida.index', compact('result'));
    }

    public function listar_unidades()
    {
        $result = ParUnidadmedida::where('eliminado', 0)->get();
        return response()->json($result);
    }

    
    // Almacena los datos del formulario en la base de datos
    public function store(Request $request)
    {
        $request->validate(
            [
                'nombre' => 'required|string|max:255',
                'simbolo' => 'required|max:255',

            ],
            [
                'nombre.required' => 'Debe ingresar el nombre de la unidad de medida',
                'simbolo.required' => 'Debe ingresar el simbolo de la unidad de medida',
                'nombre.max' => 'El nombre de la unidad de medida no puede superar los 255 caracteres',
                'simbolo.max' => 'El simbolo de la unidad de medida no puede superar los 255 caracteres',

            ]
        );
        if($request->id==null){
            ParUnidadmedida::updateOrCreate(
                ['idpar_unidadmedida'=>$request->id],
                [
                    'nombre' => $request->nombre,
                    'simbolo' => $request->simbolo,
                    'usuario_creacion' => Auth::user()->id,
                    'fecha_creacion' => now(),
                ]
            );        
        }else{
            ParUnidadmedida::updateOrCreate(
                ['idpar_unidadmedida'=>$request->id],
                [
                    'nombre' => $request->nombre,
                    'simbolo' => $request->simbolo,
                    'usuario_modificacion' => Auth::user()->id,
                    'fecha_modificacion' => now(),
                ]
            );
        }

        $result = ParUnidadmedida::where('eliminado', 0)->get();
        return response()->json($result);
    }


    public function destroy($id)
    {
        $contenido=RepFormulariocontenido::where('idpar_unidadmedida',$id)->get();
        if($contenido->count()>0){
            foreach ($contenido as $key => $value) {
                $value->idpar_unidadmedida=NULL;
                $value->usuario_modificacion=Auth::user()->name;
                $value->fecha_modificacion=now();
                $value->save();
            }
        }
        
        $data = ParUnidadmedida::find($id);
        $data->eliminado = true;
        $data->usuario_modificacion = auth()->user()->username;
        $data->fecha_modificacion = now();
        $data->save();

        return $data;
    }
}
