<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ParTipoformulario;
use App\Models\RepFormularioseccion;
use Illuminate\Support\Facades\Auth;
use App\Models\RepFormulariocontenido;
use Illuminate\Support\Facades\Storage;
use RealRashid\SweetAlert\Facades\Alert;
use App\Models\RepFormularioplanilladato;
use Illuminate\Validation\Rules\RequiredIf;
use App\Http\Requests\TipoFormularioRequest;
use App\Models\RepFormularioplanillaregistro;

class ParTipoformularioController extends Controller
{
    private $perfil,$unidad,$institucion,$nombre_unidad,$nombre_institucion;

    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index()
    {   
        $tipos_formulario = ParTipoformulario::where('eliminado', 0)->orderBy('idpar_tipoformulario')->get();
        return view('tipo_formulario.index',compact('tipos_formulario'));
    }

    public function listar_tipo_formulario()
    {
   
        $result = ParTipoformulario::where('eliminado', 0)->orderBy('idpar_tipoformulario')->get();

        return response()->json($result);
    }

    public function create(){
        $parTipoformulario=new ParTipoformulario();
        return view('tipo_formulario.create',compact('parTipoformulario'));
    }
    public function store(TipoFormularioRequest $request)
    {
        $parTipoformulario = new ParTipoformulario();
        $parTipoformulario->tipo = $request->tipo;
        $parTipoformulario->nombre = $request->nombre;
        $parTipoformulario->slug = $request->slug;
        $parTipoformulario->descripcion = $request->descripcion;
        $parTipoformulario->color_subtitulo = $request->color_subtitulo;
        $parTipoformulario->color_titulo = $request->color_titulo;
        $parTipoformulario->codigo = $request->codigo;
        $parTipoformulario->descripcion_campo_obligatorio = $request->descripcion_campo_obligatorio;
        $parTipoformulario->orientacion_impresion = $request->orientacion_impresion;
        $parTipoformulario->color_fondo = $request->color_fondo;
        $parTipoformulario->color_texto = $request->color_texto;
        $parTipoformulario->mensaje_de_llenado_formulario = $request->mensaje_de_llenado_formulario;
        $parTipoformulario->mensaje_de_formulario_deshabilitado = $request->mensaje_de_formulario_deshabilitado;

        if ($request->hasFile('logo')) {
            $logo = $request->file('logo');
            $logoName = uniqid('logo_').'.'.$logo->getClientOriginalExtension();
            $logo->move(public_path('img'), $logoName);
            $parTipoformulario->logo = $logoName;
        }
        
        if ($request->hasFile('fondo')) {
            $fondoFile = $request->file('fondo');
            $fondoName = uniqid('fondo_') . '.' . $fondoFile->getClientOriginalExtension();
            $fondoFile->move(public_path('img'), $fondoName);
            $parTipoformulario->fondo = $fondoName;
        }

        $parTipoformulario->save();
    
        Alert::success('Registro agregado correctamente!');

        return redirect()->route('tipo_formulario.index');
    }

    public function cambiar_estado(Request $request)
    {
        $request->validate([
            'fecha_inicio' => ['required_if:estado,true'],
            'fecha_fin' => ['required_if:estado,true'],
            'estado' => 'required',
        ], [
            'fecha_inicio.required_if' => 'Debe ingresar la fecha de inicio de la publicación cuando el estado es activo',
            'fecha_fin.required_if' => 'Debe ingresar la fecha de fin de la publicación cuando el estado es activo',
            'estado.required' => 'Debe seleccionar el estado',
        ]);
         
        $parTipoformulario = ParTipoformulario::find($request->id);
        $parTipoformulario->fecha_inicio = $request->fecha_inicio;
        $parTipoformulario->fecha_fin = $request->fecha_fin;
        $parTipoformulario->estado = $request->estado;
        $parTipoformulario->usuario_modificacion = Auth::user()->name;
        $parTipoformulario->fecha_modificacion = now();
        $parTipoformulario->save();
    
        return redirect()->route('tipo_formulario.index');
    }

    public function edit(ParTipoformulario $parTipoformulario){
        return view('tipo_formulario.edit',compact('parTipoformulario'));
    }

    public function update(TipoFormularioRequest $request, ParTipoformulario $parTipoformulario)
    {
        $parTipoformulario->tipo = $request->tipo;
        $parTipoformulario->nombre = $request->nombre;
        $parTipoformulario->slug = $request->slug;
        $parTipoformulario->descripcion = $request->descripcion;
        $parTipoformulario->color_subtitulo = $request->color_subtitulo;
        $parTipoformulario->color_titulo = $request->color_titulo;
        $parTipoformulario->codigo = $request->codigo;
        $parTipoformulario->descripcion_campo_obligatorio = $request->descripcion_campo_obligatorio;
        $parTipoformulario->orientacion_impresion = $request->orientacion_impresion;
        $parTipoformulario->color_fondo = $request->color_fondo;
        $parTipoformulario->color_texto = $request->color_texto;
        $parTipoformulario->mensaje_de_llenado_formulario = $request->mensaje_de_llenado_formulario;
        $parTipoformulario->mensaje_de_formulario_deshabilitado = $request->mensaje_de_formulario_deshabilitado;

        if ($request->eliminar_fondo == '1') {
            if ($parTipoformulario->fondo && file_exists(public_path('img/'.$parTipoformulario->fondo))) {
                unlink(public_path('img/'.$parTipoformulario->fondo));
            }
            $parTipoformulario->fondo = null;
        }

        if ($request->hasFile('logo')) {
            if ($parTipoformulario->logo && file_exists(public_path('img/'.$parTipoformulario->logo))) {
                unlink(public_path('img/'.$parTipoformulario->logo));
            }
            $logo = $request->file('logo');
            $logoName = uniqid('logo_').'.'.$logo->getClientOriginalExtension();
            $logo->move(public_path('img'), $logoName);
            $parTipoformulario->logo = $logoName;
        }
        
        if ($request->hasFile('fondo')) {
            $fondoFile = $request->file('fondo');
            $fondoName = uniqid('fondo_') . '.' . $fondoFile->getClientOriginalExtension();
            $fondoFile->move(public_path('img'), $fondoName);
            $parTipoformulario->fondo = $fondoName;
        }

        $parTipoformulario->save();

        Alert::success('Tipo de formulario actualizado correctamente');

        return redirect()->route('tipo_formulario.index');
    }

    public function destroy($id)
    {
        // $sw=0;
        // $registros = RepFormularioplanilladato::where('idpar_tipoformulario', $id)->get();
        // if(count($registros) > 0){
        //     foreach ($registros as $d) {
        //         $d->delete();
        //         $datos=RepFormularioplanillaregistro::where('idrep_formularioplanilladato',$d->idrep_formularioplanilladato)->get();
        //         if(count($datos)>0){
        //             foreach ($datos as $reg) {
        //                 $reg->delete();
        //             }
        //         }
        //     }
        //     $sw=1;
        // }
        // $secciones = RepFormularioseccion::where('idpar_tipoformulario', $id)->get();
        // if($secciones->count()>0){
        //     foreach ($secciones as $sec) {
        //         $sec->delete();
        //         $contenido = RepFormulariocontenido::where('idrep_formularioseccion', $sec->idrep_formularioseccion)->get();
        //         if($contenido->count()>0){
        //             foreach ($contenido as $cont) {
        //                 $cont->delete();
        //             }
        //         }
        //     }
        // }
        $parTipoformulario = ParTipoformulario::find($id);
        $parTipoformulario->delete();
        
        return $parTipoformulario;
    }
}
