<?php

namespace App\Http\Controllers;

use App\Models\Item;
use App\Models\ParItem;
use Illuminate\Http\Request;
use App\Models\CuerpoFormulario;
use Illuminate\Support\Facades\Auth;
use App\Models\RepFormulariocontenido;
use RealRashid\SweetAlert\Facades\Alert;

class ParItemController extends Controller
{
    public function index(){
        $items=ParItem::where('eliminado',false)->get();
        return view('items.index',compact('items'));
    }

    public function listar_items(){
        $items=ParItem::where('eliminado',false)->with(['ubicacion','ubicacion.seccion','ubicacion.seccion.formulario'])->orderBy('nombre','asc')->get();
        return response()->json($items);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function update(Request $request)
    {
        $this->validate($request,[
            'nombre'=>'required',
        ]);
        
        $item=ParItem::find($request->idpar_item);
        $item->nombre=$request->nombre;
        $item->usuario_modificacion=Auth::user()->name;
        $item->fecha_modificacion=now();
        $item->save();

        Alert::success('Campo actualizado correctamente');
        return redirect()->route('items.index');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $contenido=RepFormulariocontenido::where('idpar_item',$id)->where('eliminado',false)->get();
        if(count($contenido)>0){
            foreach ($contenido as $key => $value) {
                $value->eliminado=true;
                $value->usuario_modificacion=Auth::user()->name;
                $value->fecha_modificacion=now();
                $value->save();
            }
        }
        
        $item = ParItem::find($id);
        $item->eliminado=true;
        $item->usuario_modificacion=Auth::user()->name;
        $item->fecha_modificacion=now();
        $item->save();

        return $item;
    }
}
