<?php

namespace App\Http\Controllers;


use App\Models\ParEmpresa;
use Illuminate\Http\Request;

class ParEmpresaController extends Controller
{

    public function index()
    {
        $result = ParEmpresa::where('eliminado', 0)->get();
        return view('empresa.index', compact('result'));
    }

    // Almacena los datos del formulario en la base de datos
    public function store(Request $request)
    {
        // Validar los datos
        $this->validateForm($request);
        $data = new ParEmpresa();
        $data->nombre = $request->nombre;
        $data->sigla = $request->sigla;
        $data->estado = $request->estado;
        // Obtener el archivo de la imagen
        $img = $request->file('image');

        if ($img) {
            // Obtener el nombre original del archivo
            $name = uniqid() . $img->getClientOriginalName();
            // Definir la ruta donde se almacenará la imagen
            $path = public_path() . '/img/';
            // Al usar move, podemos guardar el archivo con su nombre original            
            $img->move($path, $name);
            $data->logo = $name;
        } else
            $data->logo = "";

        $data->usuario_creacion = auth()->user()->username;
        $data->fecha_creacion = now();

        $data->save();
        return response()->json('Registro guardado correctamente!');
    }

    public function edit($id)
    {
        $datos = ParEmpresa::find($id);
        return response()->json($datos);
    }
    public function update(Request $request, $id)
    {
        $this->validateForm($request);

        $data = ParEmpresa::find($id);
        $data->nombre = $request->nombre;
        $data->sigla = $request->sigla;
        $data->color = $request->color;
        // Obtener el archivo de la imagen
        $img = $request->file('image');


        if ($img) {
            // Obtener el nombre original del archivo
            $name = uniqid() . $img->getClientOriginalName();
            // Definir la ruta donde se almacenará la imagen
            $path = public_path() . '/img/';
            // Al usar move, podemos guardar el archivo con su nombre original            
            $img->move($path, $name);
            $data->logo = $name;
        }

        $data->usuario_modificacion = auth()->user()->username;
        $data->fecha_modificacion = now();

        $data->save();
        return $data;
    }

    public function destroy($id)
    {
        $data = ParEmpresa::find($id);
        $data->eliminado = true;

        $data->usuario_modificacion = auth()->user()->username;
        $data->fecha_modificacion = now();

        $data->save();
        return $data;
    }
    public function validateForm($request)
    {
        $request->validate(
            [
                'nombre' => 'required|string|regex:/^[\pL\s\-]+$/u|max:255',
                'sigla' => 'required|string|alpha|max:10',
                'image' => 'nullable|image|mimes:jpg,png,jpeg,gif|max:2048',
            ],
            [
                'nombre.required' => 'Nombre de la empresa no debe ser vacio',
                'nombre.regex' => 'Nombre de la empresa corresponde al formato',
                'sigla.required' => 'Sigla no debe ser vacio',
                'sigla.alpha' => 'Sigla no debe contener numeros',
                'image.required' => 'Debe subir una imagen',
                'image.image' => 'Debe ser un archivo de tipo jpg,png o jpeg',
                'image.max' => 'El peso maximo es de 2MB',
            ]
        );
    }
}
