<?php

namespace App\Http\Controllers;

use App\Models\ParTipoformulario;
use App\Models\Variable;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;
use App\Models\RepFormularioseccion;
use App\Models\RepFormularioplanilladato;


class HomeController extends Controller
{
  /**
   * Create a new controller instance.
   *
   * @return void
   */
  

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $conteo=RepFormularioplanilladato::where('eliminado',false)->where('estado',true)->select(DB::raw('idpar_tipoformulario,COUNT(idrep_formularioplanilladato) as total'))->groupBy('idpar_tipoformulario')->get();
        //dd($conteo);
        $formularios=ParTipoformulario::where('eliminado',false)->orderBy('idpar_tipoformulario','asc')->get();
        return view('home',compact('conteo','formularios'));
    }

    public function grafico_general($id,$fecha,$tipoFormulario){
        
        $datos=DB::select("SELECT pd.fecha_registro_formulario,cont.idpar_item,cont.idrep_formularioseccion,item.nombre as item, sec.nombre as seccion, SUM(CAST(pr.valor AS DECIMAL)) as total
        FROM rep_formularioplanilladato pd INNER JOIN rep_formularioplanillaregistro pr on pr.idrep_formularioplanilladato=pd.idrep_formularioplanilladato
        INNER JOIN rep_formulariocontenido cont on cont.idrep_formulariocontenido=pr.idrep_formulariocontenido
        INNER JOIN rep_formularioseccion sec on cont.idrep_formularioseccion=sec.idrep_formularioseccion
        INNER JOIN par_item item on cont.idpar_item=item.idpar_item
        where pd.idpar_tipoformulario=$tipoFormulario and pd.eliminado is false and pd.fecha_registro_formulario='$fecha' and cont.idrep_formularioseccion=$id and pd.estado is true and tipo_campo in ('numeric','decimal')
        GROUP BY pd.fecha_registro_formulario,cont.idpar_item, cont.idrep_formularioseccion,item.nombre, sec.nombre
        ORDER BY pd.fecha_registro_formulario");
        $datos_conteo=[];
    
        return response()->json([$datos,$datos_conteo]);
        
    }
    
    public function coordenadas(Request $request)
    {
        $empresa = $request->empresa ?? [];
        $tipo = $request->tipo ?? [];

        $query = DB::connection('pgsql_coordenadas')->table('ubicacion_planta');

        // FILTRO EMPRESA
        if (!empty($empresa) && !in_array("__ALL__", $empresa)) {
            $query->whereIn('empresa', $empresa);
        }

        // FILTRO TIPO
        if (!empty($tipo) && !in_array("__ALL__", $tipo)) {
            $query->whereIn('tipoinfraestructura', $tipo);
        }

        $datos = $query->get();

        // listas
        $empresas = DB::connection('pgsql_coordenadas')
            ->table('ubicacion_planta')
            ->select('empresa')->distinct()->get();

        $tipos = DB::connection('pgsql_coordenadas')
            ->table('ubicacion_planta')
            ->select('tipoinfraestructura')->distinct()->get();

        return view('coordenadas', compact('datos', 'empresas', 'tipos', 'empresa', 'tipo'));
    }
}
