<?php

namespace App\Http\Controllers\Auth;

use App\Models\User;
use App\Models\RoleUser;
use LdapRecord\Container;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\User as UserLocal;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Role;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use YoHang88\LetterAvatar\LetterAvatar;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use LdapRecord\Models\ActiveDirectory\User as LdapUser;


class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
        $this->middleware('auth')->only('logout');
    }

    public function username()
    {
        return 'username';
    }
   
    public function login(Request $request)
    {
        $request->validate([
            'username' => 'required|string',
            'password' => 'required|string',
            'captcha' => 'required'
        ], [
            'username.required' => 'Debe ingresar el nombre de usuario asignado',
            'password.required' => 'Debe ingresar su contraseña',
            'captcha.required' => 'El campo captcha es obligatorio',
            
        ]);
        
        $captchaValidation = captcha_check($request->captcha);
        if (!$captchaValidation) {
            return redirect()->back()
                ->withErrors(['captcha' => 'El código captcha ingresado no es correcto.'])
                ->withInput($request->except('password'));
        }
        
        $credentials = $request->only('username', 'password');

        $ldapUser = LdapUser::where('samaccountname', '=', $credentials['username'])->first();
    // $ldapUser=null;
        if ($ldapUser) {
            // Autenticación en LDAP
            if (Container::getConnection()->auth()->attempt($ldapUser->getDn(), $credentials['password'])) {
                $samAccountName = $ldapUser->getFirstAttribute('samaccountname');
                if(UserLocal::where('username', $ldapUser->getFirstAttribute('samaccountname'))->exists()){
                    $usuario = UserLocal::where('username', $samAccountName)->first();
    
                    if($usuario) {
                        Auth::guard('web')->login($usuario);
                        return redirect()->intended('home');
                    } else {
                        return back()->withErrors([
                            'message' => 'Error al obtener datos del usuario, comuniquese con el administrador del sistema.',
                        ]);
                    }
                }
                else{
                    return back()->withErrors([
                        'message' => 'No tiene acceso al sistema, comuniquese con el administrador del sistema.',
                    ]);
                }
            }
            else{
                $attempt = Auth::attempt($credentials);
                if($attempt){
                    return redirect()->intended('home');
                }
                else{
                    return back()->withErrors([
                        'message' => 'No tiene acceso al sistema, comuniquese con el administrador del sistema AD.',
                    ]);
                }
            }
        }
        else{
            $attempt = Auth::attempt($credentials);
            if($attempt){
                return redirect()->intended('home');
            }
            else{
                return back()->withErrors([
                    'message' => 'No tiene acceso al sistema, comuniquese con el administrador del sistema.',
                ]);
            }
        }
    }
    public function refreshCaptcha()
    {
        // Versión mejorada para asegurar que retorna HTML válido
        return response()->json(['captcha' => captcha_img('large')]);
    }

    public function logout(Request $request)
    {
        // Verifica si el usuario está autenticado
        if (Auth::check()) {
            Auth::logout();
            $request->session()->invalidate();
            $request->session()->regenerateToken();
            return redirect('/login')->with('message', 'Sesión cerrada correctamente.');
        }

        return response()->json(['message' => 'Session closed in system 2'], 200);
    }
}
