<?php

namespace App\Exports\Sheets;

use Illuminate\View\View;
use Maatwebsite\Excel\Sheet;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithEvents;


class RegistrosTablaSheet implements FromView, WithEvents, WithTitle
{
    use Exportable;

    public $secciones;
    public $registros;
    public function __construct($registros,$secciones)
    {
        $this->secciones = $secciones;
        $this->registros = $registros;
    }

    public function view(): View
    {
        
        return view('registro.xls.registros_tabla', [
            'secciones' => $this->secciones,
            'registros' => $this->registros,
        ]);
    }
    public function registerEvents(): array
    {
        Sheet::macro('freezePane', function (Sheet $sheet, $pane) {
            $sheet->getDelegate()->freezePane($pane);  // <-- https://stackoverflow.com/questions/49678273/setting-active-cell-for-excel-generated-by-phpspreadsheet
        });

        Sheet::macro('styleCells', function (Sheet $sheet, string $cellRange, array $style) {
            $sheet->getDelegate()->getStyle($cellRange)->applyFromArray($style);
        });

        Sheet::macro('setWrapText', function (Sheet $sheet, string $cellRange) {
            $sheet->getDelegate()->getStyle($cellRange)->getAlignment()->setWrapText(true);
        });

        return [
            AfterSheet::class => function(AfterSheet $event) {
                $styleArray = [
                    'font' => [
                        'bold' => true
                    ]
                ];
                $styleArrayTitle = [
                    'font' => [
                        'bold' => true,
                        'size' => 14
                    ]
                ];
                $to = $event->sheet->getDelegate()->getHighestRowAndColumn();
                $event->sheet->setWrapText('A1:'.$to['column'].$to['row']);
                $event->sheet->styleCells(
                    'A2:'.$to['column'].$to['row'],
                    [
                        'borders' => [
                            'allBorders' => [
                                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            ],
                        ],
                    ]
                );
                $cellRange2 = 'A2:'.$to['column'].'2';
                $event->sheet->freezePane('A3', 'A3');
                $event->sheet->getStyle($cellRange2)->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                $event->sheet->getStyle('A')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);
                $event->sheet->getDelegate()->getStyle($cellRange2)->applyFromArray($styleArray);
                $event->sheet->getDelegate()->getStyle('A1')->applyFromArray($styleArrayTitle);
                $event->sheet->setAutoFilter($cellRange2);
            },
        ];
    }

    public function title(): string
    {
        return 'Registros Tabla';
    }
}
