<?php

namespace App\Exports;

use App\Exports\Sheets\RegistrosFormularioSheet;
use Maatwebsite\Excel\Concerns\Exportable;
use App\Exports\Sheets\RegistrosTablaSheet;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;


class RegistrosDosHojasExport implements WithMultipleSheets
{
    use Exportable;

    public $secciones;
    public $registros;
    public $parTipoformulario;
    public $tabla;
    public $cabecera;

    public function __construct($secciones, $registros, $parTipoformulario,$tabla,$cabecera)
    {
        $this->secciones = $secciones;
        $this->registros = $registros;
        $this->tabla = $tabla;
        $this->parTipoformulario = $parTipoformulario;
        $this->cabecera = $cabecera;

    }


    public function sheets(): array
    {
        $sheets = [];
        $sheets[] = new RegistrosFormularioSheet($this->secciones,$this->registros,$this->parTipoformulario);
        $sheets[] = new RegistrosTablaSheet($this->tabla,$this->cabecera);
        return $sheets;
    }
}
