<!DOCTYPE html>
<html lang="en" class="h-100">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Ingreso - <?php echo e(config('app.name')); ?></title>
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('images/favicon-16x16.png')); ?>">
    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">

</head>

<body class="h-100">
    <div class="authincation h-100">
        <div class="container-fluid h-100">
            <div class="row justify-content-center h-100 align-items-center">
                <div class="col-md-4">
                    <div class="authincation-content">
                        <div class="row no-gutters">
                            <div class="col-xl-12">
                                <div class="auth-form">
                                    <img src="<?php echo e(asset('images/sigecon.png')); ?>" alt="Sigecon Logo" class="img-fluid mb-4" style="width: 100%; height: auto;">
                                    <h4 class="text-center mb-4">Ingrese sus credenciales</h4>
                                    <?php if($errors->any()): ?>
                                        <div class="alert alert-outline-danger">
                                            <strong>Debe corregir los siguientes errores:</strong>
                                            <ul>
                                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><?php echo e($error); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                    <?php endif; ?>
                                    <form method="POST" action="<?php echo e(route('login')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-group">
                                            <label><strong>Nombre de Usuario</strong></label>
                                            <input type="text" class="form-control <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name ="username" id="username">
                                        </div>
                                        <div class="form-group">
                                            <label><strong>Password</strong></label>
                                            <input type="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="password" id="password">
                                        </div>
                                        <div class="form-group">
                                            <label>Código de verificación:</label>
                                            <div class="captcha-container text-center">
                                                <div class="captcha-image-container">
                                                    <img id="captcha-image" src="<?php echo e(captcha_src('default')); ?>" alt="Captcha" style="height: 80px;  width: 250px;">
                                                    <button type="button" class="btn btn-rounded btn-icon btn-info" onclick="refreshCaptcha()" id="refresh-button">
                                                        <span
                                                            class="btn-icon-left text-primary"><i class="fa fa-refresh"></i>
                                                        </span>
                                                    </button>
                                                </div>
                                                <div class="captcha-controls">
                                                    <small class="text-muted">Ingresa el código que ves en la imagen</small>
                                                    <span id="countdown" class="countdown-text"></span>
                                                </div>
                                            </div>
                                            <input type="text" name="captcha" placeholder="Ingresa el código" class="form-control <?php $__errorArgs = ['captcha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="captcha">
                                        </div>
                                        <div class="form-row d-flex justify-content-between mt-4 mb-2">
                                            <div class="form-group">
                                                <div class="form-check ml-2">
                                                    <input class="form-check-input" type="checkbox" name="remember" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="remember">Recordar mi sesión</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="text-center">
                                            <button type="submit" class="btn btn-primary btn-block">Ingresar</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!--**********************************
        Scripts
    ***********************************-->
    <!-- Required vendors -->
    <script src="<?php echo e(asset('vendor/global/global.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/quixnav-init.js')); ?>"></script>
    <script src="<?php echo e(asset('js/custom.min.js')); ?>"></script>
    <script>
    // URL para pedir nuevo captcha
    const url = "<?php echo e(route('refresh-captcha')); ?>";

    // Tiempo en segundos para refrescar automáticamente
    let timeLeft = 60;
    let countdownInterval;

        const captchaImage = document.getElementById('captcha-image');
        const refreshButton = document.getElementById('btn-refresh-captcha');

        // Inicia el temporizador
        startCountdown();

        // Botón de recarga manual
        refreshButton.addEventListener('click', function (e) {
            e.preventDefault();
            refreshCaptcha();
        });

        // Inicia el contador de tiempo para actualización automática
        function startCountdown() {
            clearInterval(countdownInterval);

            countdownInterval = setInterval(() => {
                timeLeft--;

                // Actualizar contador visible
                const minutes = Math.floor(timeLeft / 60);
                const seconds = timeLeft % 60;
                document.getElementById('countdown').textContent =
                    `Se renueva en: ${minutes}:${seconds.toString().padStart(2, '0')}`;

                if (timeLeft <= 0) {
                    autoRefreshCaptcha();
                }
            }, 1000);
        }

        // Refrescar captcha manualmente
        function refreshCaptcha() {
            fetch(url, {
                method: 'GET',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                captchaImage.src = data.captcha + '?' + new Date().getTime(); // evitar caché
                document.querySelector('input[name="captcha"]').value = '';
                timeLeft = 60;
                startCountdown();
            })
            .catch(error => {
                console.error('Error al refrescar manualmente el captcha:', error);
            });
        }

        // Refrescar captcha automáticamente
        function autoRefreshCaptcha() {
            fetch(url, {
                method: 'GET',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                captchaImage.src = data.captcha + '?' + new Date().getTime(); // evitar caché
                document.querySelector('input[name="captcha"]').value = '';
                timeLeft = 60;
                startCountdown();
                console.log('Captcha actualizado automáticamente');
            })
            .catch(error => {
                console.error('Error al auto refrescar captcha:', error);
                timeLeft = 60;
                startCountdown(); // reiniciar igual
            });
        }

        // Limpiar el contador al salir
        window.addEventListener('beforeunload', function () {
            clearInterval(countdownInterval);
        });
</script>

</body>

</html><?php /**PATH C:\laragon\www\contrataciones\resources\views/auth/login.blade.php ENDPATH**/ ?>