<div>
    <!-- row -->
    <div class="row">
        <div class="col-xl-12 col-xxl-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Procesos de Contratación registrados</h4>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contratos.create')): ?>
                        <a href="<?php echo e(route('procesos-contratacion.create')); ?>" class="btn btn-primary btn-round">Registrar Nuevo</a>
                    <?php endif; ?>
                </div>
                <div class="card-body">
                    <p>Filtros de Busqueda</p>
                    <div class="row mb-3">
                        <div class="col-md-2">
                            <input type="text" class="form-control" placeholder="Buscar por NURI o Código" wire:model.live="search">
                        </div>
                        <div class="col-md-3">
                            <input type="text" class="form-control" placeholder="Buscar por Objeto de Contratación" wire:model.live="searchObjetoContratacion">
                        </div>
                        <div class="col-md-3">
                            <select class="form-control" wire:model.live="filtroEntidad">
                                <option value="">Buscar por Entidad</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $entidades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entidad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($entidad->id); ?>"><?php echo e($entidad->nombre); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select class="form-control" wire:model.live="filtroAsignado">
                                <option value="">Buscar por Técnico Asignado</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $asignados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asignado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($asignado->id); ?>"><?php echo e($asignado->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                        </div>
                    
                        <div class="col-md-2">
                            <select class="form-control" wire:model.live="filtroEstado">
                                <option value="">Buscar por Estado</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($estado->id); ?>"><?php echo e($estado->nombre); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                        </div>
                    </div>
                    <div class="mb-2">
                        <!--[if BLOCK]><![endif]--><?php if($search): ?>
                            <span class="badge badge-info">
                                Código/NURI: "<?php echo e($search); ?>"
                                <a href="#" wire:click.prevent="$set('search', '')" class="text-white ml-1">✖</a>
                            </span>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($searchObjetoContratacion): ?>
                            <span class="badge badge-info">
                                Objeto: "<?php echo e($searchObjetoContratacion); ?>"
                                <a href="#" wire:click.prevent="$set('searchObjetoContratacion', '')" class="text-white ml-1">✖</a>
                            </span>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($filtroEntidad): ?>
                            <span class="badge badge-info">
                                Entidad: <?php echo e($entidades->find($filtroEntidad)?->nombre); ?>

                                <a href="#" wire:click.prevent="$set('filtroEntidad', '')" class="text-white ml-1">✖</a>
                            </span>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($filtroAsignado): ?>
                            <span class="badge badge-info">
                                Técnico: <?php echo e($asignados->find($filtroAsignado)?->name); ?>

                                <a href="#" wire:click.prevent="$set('filtroAsignado', '')" class="text-white ml-1">✖</a>
                            </span>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($filtroEstado): ?>
                            <span class="badge badge-info">
                                Estado: <?php echo e($estados->find($filtroEstado)?->nombre); ?>

                                <a href="#" wire:click.prevent="$set('filtroEstado', '')" class="text-white ml-1">✖</a>
                            </span>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($search || $searchObjetoContratacion || $filtroEntidad || $filtroAsignado || $filtroEstado): ?>
                            <button wire:click="resetFiltros" class="btn btn-sm btn-outline-danger ml-2">Limpiar todos</button>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <h4>Listado de Contratos </h4>
                    <div class="table-responsive">
                        <table class="table table-hover" id="datos">
                            <thead>
                                <tr>
                                    <th class="text-center">ACCIONES</th>
                                    <th class="text-center">CODIGO</th>
                                    <th class="text-center">NURI</th>
                                    <th class="text-center">FECHA INGRESO</th>
                                    <th class="text-center">OBJETO CONTRATACIÓN</th>
                                    <th class="text-center">TECNICO ASIGNADO</th>
                                    <th class="text-center">UNIDAD SOLICITANTE</th>
                                    <th class="text-center">PRECIO REFERENCIAL</th>
                                    <th class="text-center">ESTADO ACTUAL</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $contratos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contrato): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td class="d-flex align-items-center justify-content-center">
                                            
                                            
                                            <a href="<?php echo e(route('contratos.edit', $contrato->id)); ?>" class="btn btn-sm btn-outline-warning" title="Modificar datos del Contrato"><i class="fa fa-edit"></i></a>
                                            
                                            <a href="<?php echo e(route('contratos.show', $contrato->id)); ?>" class="btn btn-sm btn-outline-info" title="Ver Contrato" target="_blank"><i class="fa fa-file-pdf-o"></i></a>
                                            
                                            <a href="javascript:void(0);" 
                                                class="btn btn-sm btn-outline-danger delete-btn"
                                                data-id="<?php echo e($contrato->id); ?>" 
                                                title="Eliminar contrato">
                                                <i class="fa fa-trash"></i>
                                            </a>
                                            <a href="javascript:void(0);" wire:click="$dispatch('abrir-modal-asignacion',{contratoId:<?php echo e($contrato->id); ?> })"
                                                class="btn btn-sm btn-outline-secondary" title="Asignar Técnico">
                                                <i class="fa fa-user-plus"></i>
                                            </a>
                                            <a href="javascript:void(0);" wire:click="$dispatch('abrirModalSeguimiento',{contratoId:<?php echo e($contrato->id); ?> })" class="btn btn-sm btn-outline-success">
                                                <i class="fa fa-history"></i>
                                            </a>
                                        </td>
                                        <td class="text-center"><?php echo e($contrato->codigo); ?></td>
                                        <td class="text-center"><?php echo e($contrato->nuri); ?></td>
                                        <td class="text-center"><?php echo e(date('d/m/Y', strtotime($contrato->fecha_ingreso))); ?></td>
                                        <td><?php echo e($contrato->objeto_contratacion); ?></td>
                                        <td class="text-center"> <!--[if BLOCK]><![endif]--><?php if($contrato->ultimaAsignacion != null): ?> <label for="" class="badge badge-rounded badge-primary"><?php echo e($contrato->ultimaAsignacion?->responsable?->name); ?></label> <?php else: ?> <label for="" class="badge badge-rounded badge-danger">Sin Asignar</label> <?php endif; ?><!--[if ENDBLOCK]><![endif]--></td>
                                        <td class="text-center"><?php echo e($contrato->entidad->nombre); ?></td>
                                        <td class="text-center"><?php echo e(number_format($contrato->precio_referencial,2)); ?></td>
                                        <td class="text-center"><!--[if BLOCK]><![endif]--><?php if($contrato->ultimoSeguimiento != null): ?> <?php echo e(optional($contrato->ultimoSeguimiento)->estado->nombre); ?> <br> <?php echo e(date('d/m/Y', strtotime($contrato->ultimoSeguimiento->fecha_seguimiento))); ?> <?php else: ?> <label for="" class="badge badge-rounded badge-success">Sin Seguimiento</label> <?php endif; ?><!--[if ENDBLOCK]><![endif]--></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="9">
                                            <div class="alert alert-danger alert-outline-primary mb-0" role="alert">
                                                No hay contratos registrados.
                                            </div>
                                        </td>
                                    </tr>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </tbody>
                        </table>
                        <?php echo e($contratos->links()); ?>

                    </div> 
                </div>
            </div>
        </div>
    </div>
    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('contratos.asignar-tecnico-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-943214086-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('contratos.seguimiento-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-943214086-1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    <form id="delete-form" method="POST" style="display:none;" >
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
    </form>
    <?php $__env->startSection('scripts'); ?>
        <script>
            Livewire.on('mostrar-modal-asignacion', () => {
            const modalA = new bootstrap.Modal(document.getElementById('modalAsignacion'));
            modalA.show();
        });
        
        Livewire.on('cerrar-modal-asignacion', () => {
            const modalA = new bootstrap.Modal(document.getElementById('modalAsignacion'));
            modalA.hide();
        });

        Livewire.on('asignacion-exitosa', (data) => {
            Swal.fire({
                icon: 'success',
                title: 'Listo',
                text: data.mensaje ?? 'Técnico asignado correctamente.',
                timer: 2500,
                showConfirmButton: false
            });
        });

        Livewire.on('confirmar-reemplazo', (data) => {
            Swal.fire({
                icon: 'warning',
                title: '¿Reemplazar técnico?',
                html: `
                    <p>Actualmente asignado: <strong>${data.actual}</strong></p>
                    <p>Nuevo técnico: <strong>${data.nuevo}</strong></p>
                    <p>¿Desea continuar?</p>
                `,
                showCancelButton: true,
                confirmButtonText: 'Sí, reemplazar',
                cancelButtonText: 'Cancelar',
            }).then((result) => {
                if (result.isConfirmed) {
                    // Llama a Livewire para guardar realmente
                    Livewire.dispatch('guardarAsignacion');
                }
            });
        });

        document.addEventListener('DOMContentLoaded', function () {
            document.querySelectorAll('.delete-btn').forEach(button => {
                button.addEventListener('click', function () {
                    const itemId = this.dataset.id;
    
                    Swal.fire({
                        title: '¿Está seguro de eliminar el contrato?',
                        text: "Esta acción no se puede deshacer.",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: "#3085d6",
                        cancelButtonColor: "#d33",
                        confirmButtonText: 'Sí, eliminar',
                        cancelButtonText: 'Cancelar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            const form = document.getElementById('delete-form');
                            form.action = baseUrl + `/contratos/${itemId}/eliminar`; // Asegúrate que coincida con tu ruta
                            form.submit();
                        }
                    });
                });
            });
        });

        Livewire.on('seguimiento-guardado', () => {
            Swal.fire({
                icon: 'success',
                title: 'Seguimiento guardado',
                text: 'El seguimiento se ha guardado correctamente.',
            });
            Livewire.emit('cerrar-modal-seguimiento');
        });

        Livewire.on('mostrar-modal-seguimiento', () => {
            const modal = new bootstrap.Modal(document.getElementById('modalSeguimiento'));
            modal.show();
        });

        document.addEventListener('livewire:initialized', () => {
            window.livewire.on('cerrar-modal-seguimiento', () => {
                $('#modalSeguimiento').modal('hide');
            });
        });
    </script>
    <?php $__env->stopSection(); ?>
</div>

<?php /**PATH C:\laragon\www\contrataciones\resources\views/livewire/contrato-component.blade.php ENDPATH**/ ?>