<!-- resources/views/reportes/usuarios.blade.php -->

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title><?php echo e($contrato->codigo); ?></title>
    
    <link href="<?php echo e(asset('css/bootstrap.min.css')); ?>" rel="stylesheet">
    
    <style>
         body { font-size: 12px; }
        .form-group {
            margin-bottom: 10px;
        }
        .row {
        display: block !important;
        clear: both;
        padding: 10px 20px;
    }
    [class^="col-"] {
        float: left;
        padding: 0 10px;
        box-sizing: border-box;
    }
    .col-md-6 {
        width: 50%;
    }
    .col-md-5 {
        width: 41.66%;
    }
    .col-md-4 {
        width: 33.33%;
    }
    .col-md-3 {
        width: 25%;
    }
    .col-md-2 {
        width: 16.66%;
    }
    .col-md-12 {
        width: 100%;
    }
        input {
            width: 100%;
            padding: 4px;
            box-sizing: border-box;
        }
    </style>
</head>
<body>
    <div class="text-right">
        <h2><?php echo e($contrato->codigo); ?></h2>
        <h5>Técnico Asignado: <?php if($contrato->ultimaAsignacion != null): ?> <?php echo e($contrato->ultimaAsignacion?->responsable?->name); ?> <?php else: ?> SIN ASIGNAR <?php endif; ?> </h5>
    </div>

<div class="row">
    <div class="col-md-3">
        <div class="form-group">
            <label for="nuri">NURI Informe <span class="text-danger">(*)</span></label>
            <input type="text" class="form-control" id="nuri" name="nuri" value="<?php echo e($contrato->nuri_informe); ?>">
        </div>
    </div>
    <div class="col-md-3">
        <div class="form-group">
            <label for="codigo_pac">Código del PAC</label>
            <input type="text" class="form-control" id="codigo_pac" name="codigo_pac" value="<?php echo e($contrato->codigo_pac); ?>">
        </div>
    </div>
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="fecha_ingreso">Fecha de Ingreso <span class="text-danger">(*)</span></label>
            <input type="date" class="form-control <?php $__errorArgs = ['fecha_ingreso'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="fecha_ingreso" name="fecha_ingreso" value="<?php echo e(old('fecha_ingreso') ?? date('Y-m-d', strtotime($contrato->fecha_ingreso ?? date('Y-m-d')))); ?>">
        </div>
    </div>
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="tipo_gasto_id">Inversión / Gasto Corriente <span class="text-danger">(*)</span></label>
            
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12 ">
        <div class="form-group">
            <label for="objeto_contratacion">Objeto de la Contratación <span class="text-danger">(*)</span></label>
            <textarea name="objeto_contratacion" id="objeto_contratacion" class="form-control <?php $__errorArgs = ['objeto_contratacion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" cols="30" rows="2"><?php echo e(old('objeto_contratacion') ?? $contrato->objeto_contratacion); ?></textarea>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-4 ">
        <div class="form-group">
            <label for="normativa_id">Normativa Aplicable <span class="text-danger">(*)</span></label>
            <input type="text" name="normativa_id" id="normativa_id" class="form-control" value="<?php echo e($contrato->normativa->nombre); ?>">
        </div>
    </div>
    <div class="col-md-4 ">
        <div class="form-group">
            <label for="modalidad_id">Modalidad del Proceso <span class="text-danger">(*)</span></label>
            <input type="text" name="modalidad_id" id="modalidad_id" class="form-control" value="<?php echo e($contrato->modalidad->nombre); ?>">
        </div>
    </div>
    <div class="col-md-4 ">
        <div class="form-group">
            <label for="precio_referencial">Precio Referencial <span class="text-danger">(*)</span></label>
            <input type="text" name="precio_referencial" id="precio_referencial" class="form-control text-right" value="<?php echo e(number_format($contrato->precio_referencial,2)); ?>">
        </div>
    </div>
</div>
<hr>
<div class="row">
    <div class="col-md-2 ">
        <div class="form-group">
            <label for="fuente_organismo">Fuente / Organismo</label>
            <input type="number" name="fuente_organismo" id="fuente_organismo" class="form-control <?php $__errorArgs = ['fuente_organismo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('fuente_organismo') ?? $contrato->fuente_organismo); ?>">
        </div>
    </div>
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="numero_certificacion">N° Certificación</label>
            <input type="number" name="numero_certificacion" id="numero_certificacion" class="form-control <?php $__errorArgs = ['numero_certificacion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('numero_certificacion') ?? $contrato->numero_certificacion); ?>">
        </div>
    </div>

    <div class="col-md-2 ">
        <div class="form-group">
            <label for="fecha_autorizacion_inicio_proceso">Fecha Autorización Incio Proceso</label>
            <input type="date" name="fecha_autorizacion_inicio_proceso" id="fecha_autorizacion_inicio_proceso" class="form-control <?php $__errorArgs = ['fecha_autorizacion_inicio_proceso'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('fecha_autorizacion_inicio_proceso') ?? $contrato->fecha_autorizacion_inicio_proceso ?? ''); ?>">
        </div>
    </div>
    <div class="col-md-2 ">
        <div class="form-group">
            <label for="nro_resolucion_autorizacion">N° Resolución de Autorización</label>
            <input type="number" name="nro_resolucion_autorizacion" id="nro_resolucion_autorizacion" class="form-control <?php $__errorArgs = ['nro_resolucion_autorizacion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('nro_resolucion_autorizacion') ?? $contrato->nro_resolucion_autorizacion); ?>">
        </div>
    </div>
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="fecha_resolucion_autorizacion">Fecha de Resolución de Autorización</label>
            <input type="date" name="fecha_resolucion_autorizacion" id="fecha_resolucion_autorizacion" class="form-control <?php $__errorArgs = ['fecha_resolucion_autorizacion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('fecha_resolucion_autorizacion') ?? $contrato->fecha_resolucion_autorizacion ?? ''); ?>">
        </div>
    </div>
</div>
<hr>
<div class="row">
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="fecha_carta_adjudicacion">Fecha Elaboración carta de Adjudicación</label>
            <input type="date" name="fecha_carta_adjudicacion" id="fecha_carta_adjudicacion" class="form-control <?php $__errorArgs = ['fecha_carta_adjudicacion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('fecha_carta_adjudicacion') ?? $contrato->fecha_carta_adjudicacion ?? ''); ?>">
        </div>
    </div>
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="fecha_notificacion_adjudicacion">Fecha Notificación carta de Adjudicación</label>
            <input type="date" name="fecha_notificacion_adjudicacion" id="fecha_notificacion_adjudicacion" class="form-control <?php $__errorArgs = ['fecha_notificacion_adjudicacion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('fecha_notificacion_adjudicacion') ?? $contrato->fecha_notificacion_adjudicacion ?? ''); ?>">
        </div>
    </div>
    <div class="col-md-2 ">
        <div class="form-group">
            <label for="monto_adjudicado">Monto Adjudicado (Bs)</label>
            <input type="number" step="0.01" name="monto_adjudicado" id="monto_adjudicado" class="form-control <?php $__errorArgs = ['monto_adjudicado'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('monto_adjudicado') ?? $contrato->monto_adjudicado); ?>">
        </div>
    </div>
</div>
<hr>
<div class="row">
    <div class="col-md-2 ">
        <div class="form-group">
            <label for="fecha_remision_juridica">Fecha de Remisión Jurídica</label>
            <input type="date" name="fecha_remision_juridica" id="fecha_remision_juridica" class="form-control <?php $__errorArgs = ['fecha_remision_juridica'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> " value="<?php echo e(old('fecha_remision_juridica') ?? $contrato->fecha_remision_juridica ?? ''); ?>">
        </div>
    </div>
    <div class="col-md-2 ">
        <div class="form-group">
            <label for="fecha_retorno_juridica">Fecha de Retorno Jurídica</label>
            <input type="date" name="fecha_retorno_juridica" id="fecha_retorno_juridica" class="form-control <?php $__errorArgs = ['fecha_retorno_juridica'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('fecha_retorno_juridica') ?? $contrato->fecha_retorno_juridica ?? ''); ?>">
        </div>
    </div>

    <div class="col-md-4 ">
        <div class="form-group">
            <label for="tipo_contrato">Contrato - Orden de Compra / Servicio</label>
            <input type="text" name="tipo_contrato" id="tipo_contrato" class="form-control <?php $__errorArgs = ['tipo_contrato'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('tipo_contrato') ?? $contrato->tipo_contrato ?? ''); ?>">
        </div>
    </div>
   
</div>
<div class="row">
    <div class="col-md-2 ">
        <div class="form-group">
            <label for="fecha_contrato">Fecha de Contrato</label>
            <input type="date" name="fecha_contrato" id="fecha_contrato" class="form-control <?php $__errorArgs = ['fecha_contrato'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('fecha_contrato') ?? $contrato->fecha_contrato ?? ''); ?>">
        </div>
    </div>
    <div class="col-md-2 ">
        <div class="form-group">
            <label for="monto_contrato">Monto del Contrato</label>
            <input type="number" step="0.01" name="monto_contrato" id="monto_contrato" class="form-control <?php $__errorArgs = ['monto_contrato'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('monto_contrato') ?? $contrato->monto_contrato); ?>">
        </div>
    </div>
</div>
<hr>
<div class="row">
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="plazo_entrega">Plazo de Entrega</label>
            <input type="text" name="plazo_entrega" id="plazo_entrega" class="form-control <?php $__errorArgs = ['plazo_entrega'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('plazo_entrega') ?? $contrato->plazo_entrega); ?>">
        </div>
    </div>
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="fecha_estimada_entrega">Fecha estimada de entrega</label>
            <input type="date" name="fecha_estimada_entrega" id="fecha_estimada_entrega" class="form-control <?php $__errorArgs = ['fecha_estimada_entrega'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('fecha_estimada_entrega') ?? $contrato->fecha_estimada_entrega ?? ''); ?>">
        </div>
    </div>
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="cuce">CUCE</label>
            <input type="text" name="cuce" id="cuce" class="form-control <?php $__errorArgs = ['cuce'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('cuce') ?? $contrato->cuce); ?>">
        </div>
    </div>
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="registro_contraloria">Registro Contraloria</label>
            <input type="text" name="registro_contraloria" id="registro_contraloria" class="form-control <?php $__errorArgs = ['registro_contraloria'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('registro_contraloria') ?? $contrato->registro_contraloria); ?>">
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="fecha_informe_conformidad">Fecha informe conformidad</label>
            <input type="date" name="fecha_informe_conformidad" id="fecha_informe_conformidad" class="form-control <?php $__errorArgs = ['fecha_informe_conformidad'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('fecha_informe_conformidad') ?? $contrato->fecha_informe_conformidad ?? ''); ?>">
        </div>
    </div>
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="fecha_registro_sicoes">Fecha registro sicoes</label>
            <input type="date" name="fecha_registro_sicoes" id="fecha_registro_sicoes" class="form-control <?php $__errorArgs = ['fecha_registro_sicoes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('fecha_registro_sicoes') ?? $contrato->fecha_registro_sicoes ?? ''); ?>">
        </div>
    </div>
    <div class="col-md-6 ">
        <div class="form-group">
            <label for="situacion_proceso">Situación del Proceso</label>
            <input type="text" name="situacion_proceso" id="situacion_proceso" class="form-control <?php $__errorArgs = ['situacion_proceso'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('situacion_proceso') ?? $contrato->situacion_proceso ?? ''); ?>">
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-4 ">
        <div class="form-group">
            <label for="fecha_resimision_pago">Fecha de Resimisión de Pago</label>
            <input type="date" name="fecha_resimision_pago" id="fecha_resimision_pago" class="form-control <?php $__errorArgs = ['fecha_remision_pago'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('fecha_resimision_pago') ?? $contrato->fecha_resimision_pago ?? ''); ?>">
        </div>
    </div>
    <div class="col-md-4 ">
        <div class="form-group">
            <label for="recurrentes">Recurrentes</label> <br>

        </div>
    </div>
    <div class="col-md-4 ">
        <div class="form-group">
            <label for="tipo_adjunto_id">Tipo de Adjunto</label>

        </div>
    </div>
    
</div>
<br>
<div class="seccion">
        <h2>Historial de Seguimiento del proceso</h2>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th class="text-center">Fecha</th>
                    <th class="text-center">Estado</th>
                    <th class="text-center">Observación</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $contrato->seguimientos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seguimiento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="text-center"><?php echo e(\Carbon\Carbon::parse($seguimiento->fecha_seguimiento)->format('d/m/Y')); ?></td>
                        <td class="text-center"><?php echo e($seguimiento->estado->nombre); ?></td>
                        <td class="text-center"><?php echo e($seguimiento->observacion); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
            </tbody>
        </table>
    </div>
</body>
</html>
<?php /**PATH C:\laragon\www\contrataciones\resources\views/procesos/show.blade.php ENDPATH**/ ?>