<?php

use Livewire\Livewire;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\EmpresaController;
use App\Http\Controllers\ParametroController;
use App\Http\Controllers\AsignacionController;
use App\Http\Controllers\SeguimientoController;
use App\Http\Controllers\ProcesoContratacionController;

Route::get('/', function () {
    return view('auth.login');
});

Auth::routes();

Route::get('sso-login', [App\Http\Controllers\SsoAutenticacionSeguridadController::class, 'autenticacion']);
Route::get('/refresh-captcha', [App\Http\Controllers\Auth\LoginController::class, 'refreshCaptcha'])->name('refresh-captcha');

Route::middleware(['auth'])->group(function(){
    // Livewire::setUpdateRoute(function ($handle) {
    //     return Route::post('/contrataciones/public/livewire/update', $handle);
    // });

    Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
    //Roles
    Route::post('roles/store',[App\Http\Controllers\RoleController::class,'store'])->name('roles.store')->middleware('permission:roles.create');
    Route::get('roles',[App\Http\Controllers\RoleController::class,'index'])->name('roles.index')->middleware('permission:roles.index');
    Route::get('roles/create',[App\Http\Controllers\RoleController::class,'create'])->name('roles.create')->middleware('permission:roles.create');
    Route::put('roles/{role}',[App\Http\Controllers\RoleController::class,'update'])->name('roles.update')->middleware('permission:roles.edit');
    Route::get('roles/{role}',[App\Http\Controllers\RoleController::class,'show'])->name('roles.show')->middleware('permission:roles.show');
    Route::delete('roles/{role}',[App\Http\Controllers\RoleController::class,'destroy'])->name('roles.destroy')->middleware('permission:roles.destroy');
    Route::get('roles/{role}/edit',[App\Http\Controllers\RoleController::class,'edit'])->name('roles.edit')->middleware('permission:roles.edit');
    
    //Userd
    Route::post('users/store',[App\Http\Controllers\UserController::class,'store'])->name('users.store')->middleware('permission:users.create');
    Route::get('users',[App\Http\Controllers\UserController::class,'index'])->name('users.index')->middleware('permission:users.index');
    Route::get('users/create',[App\Http\Controllers\UserController::class,'create'])->name('users.create')->middleware('permission:users.create');
    Route::put('users/{user}',[App\Http\Controllers\UserController::class,'update'])->name('users.update')->middleware('permission:users.edit');
    Route::get('users/{user}/eliminar',[App\Http\Controllers\UserController::class,'destroy'])->name('users.destroy')->middleware('permission:users.destroy');
    Route::get('users/{user}/edit',[App\Http\Controllers\UserController::class,'edit'])->name('users.edit')->middleware('permission:users.edit');
    
    //Permisos
    Route::post('permisos/store',[App\Http\Controllers\PermissionController::class,'store'])->name('permisos.store')->middleware('permission:permisos.create');
    Route::get('permisos',[App\Http\Controllers\PermissionController::class,'index'])->name('permisos.index')->middleware('permission:permisos.index');
    Route::get('permisos/create',[App\Http\Controllers\PermissionController::class,'create'])->name('permisos.create')->middleware('permission:permisos.create');
    Route::put('permisos/{permiso}',[App\Http\Controllers\PermissionController::class,'update'])->name('permisos.update')->middleware('permission:permisos.edit');
    Route::get('permisos/{permiso}/eliminar',[App\Http\Controllers\PermissionController::class,'destroy'])->name('permisos.destroy')->middleware('permission:permisos.destroy');
    Route::get('permisos/{permiso}/edit',[App\Http\Controllers\PermissionController::class,'edit'])->name('permisos.edit')->middleware('permission:permisos.edit');

    //PARAMETROS
    Route::get('/parametros', [ParametroController::class, 'index'])->name('parametros.index')->middleware('permission:parametros.index');
    Route::get('/parametros/get-by-tipo', [ParametroController::class, 'getByTipo'])->name('parametros.get-by-tipo')->middleware('permission:parametros.index');
    Route::post('/parametros', [ParametroController::class, 'store'])->name('parametros.store')->middleware('permission:parametros.create');
    Route::get('/parametros/{id}', [ParametroController::class, 'show'])->name('parametros.show')->middleware('permission:parametros.show');
    Route::put('/parametros/{id}', [ParametroController::class, 'update'])->name('parametros.update')->middleware('permission:parametros.edit');
    Route::delete('/parametros/{id}', [ParametroController::class, 'destroy'])->name('parametros.destroy')->middleware('permission:parametros.destroy');

    //CONTRATOS
    Route::post('contratos/store',[App\Http\Controllers\ProcesoController::class,'store'])->name('contratos.store')->middleware('permission:contratos.create');
    Route::get('contratos',[App\Http\Controllers\ProcesoController::class,'index'])->name('contratos.index')->middleware('permission:contratos.index');
    Route::get('contratos/create',[App\Http\Controllers\ProcesoController::class,'create'])->name('contratos.create')->middleware('permission:contratos.create');
    Route::put('contratos/{contrato}',[App\Http\Controllers\ProcesoController::class,'update'])->name('contratos.update')->middleware('permission:contratos.edit');
    Route::get('contratos/{contrato}',[App\Http\Controllers\ProcesoController::class,'show'])->name('contratos.show')->middleware('permission:contratos.show');
    Route::delete('contratos/{contrato}/eliminar',[App\Http\Controllers\ProcesoController::class,'destroy'])->name('contratos.destroy')->middleware('permission:contratos.destroy');
    Route::get('contratos/{contrato}/edit',[App\Http\Controllers\ProcesoController::class,'edit'])->name('contratos.edit')->middleware('permission:contratos.edit');
    
    //Asignaciones
    Route::get('/asignaciones', [AsignacionController::class, 'index'])->name('asignaciones.index')->middleware('permission:asignaciones.index');
    Route::get('/asignaciones/get-by-tipo', [AsignacionController::class, 'getByTipo'])->name('asignaciones.get-by-tipo')->middleware('permission:asignaciones.index');
    Route::post('/asignaciones', [AsignacionController::class, 'store'])->name('asignaciones.store')->middleware('permission:asignaciones.create');
    Route::get('/asignaciones/{asignacion}', [AsignacionController::class, 'show'])->name('asignaciones.show')->middleware('permission:asignaciones.show');
    Route::put('/asignaciones/{asignacion}', [AsignacionController::class, 'update'])->name('asignaciones.update')->middleware('permission:asignaciones.edit');
    Route::delete('/asignaciones/{asignacion}/eliminar', [AsignacionController::class, 'destroy'])->name('asignaciones.destroy')->middleware('permission:asignaciones.destroy');
    
    //Seguimientos
    Route::get('/seguimientos', [SeguimientoController::class, 'index'])->name('seguimientos.index')->middleware('permission:seguimientos.index');
    Route::get('/seguimientos/get-by-tipo', [SeguimientoController::class, 'getByTipo'])->name('seguimientos.get-by-tipo')->middleware('permission:seguimientos.index');
    Route::post('/seguimientos', [SeguimientoController::class, 'store'])->name('seguimientos.store')->middleware('permission:seguimientos.create');
    Route::get('/seguimientos/{seguimiento}', [SeguimientoController::class, 'show'])->name('seguimientos.show')->middleware('permission:seguimientos.show');
    Route::put('/seguimientos/{seguimiento}', [SeguimientoController::class, 'update'])->name('seguimientos.update')->middleware('permission:seguimientos.edit');
    Route::delete('/seguimientos/{seguimiento}', [SeguimientoController::class, 'destroy'])->name('seguimientos.destroy')->middleware('permission:seguimientos.destroy');
    
    //EMPRESAS
    Route::resource('empresas', EmpresaController::class);
    Route::post('/empresas/ajax', [EmpresaController::class, 'storeAjax'])->name('empresas.storeAjax');
    Route::get('/empresas_select', [EmpresaController::class, 'getSelectOptions'])->name('empresas.select');

    Route::get('/procesos-contratacion', [ProcesoContratacionController::class, 'index'])->name('procesos-contratacion.index');    
    Route::get('/nuevo-proceso', [ProcesoContratacionController::class, 'create'])->name('procesos-contratacion.create');    
});
