<div>
    <div class="row">
        <div class="col-xl-12 col-xxl-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Datos Generales</h4>
                </div>
                <div class="card-body">
                    
                        <div class="row">
                            <div class="col-md-2 col-sm-12">
                                <div class="form-group">
                                    <label for="fecha_ingreso">Fecha de Ingreso <span class="text-danger">(*)</span></label>
                                    <input type="date" class="form-control @error('fecha_ingreso') error @enderror" wire:model.live="fecha_ingreso">
                                    @error('fecha_ingreso') <div class="text-danger text-xs">{{ $message }}</div> @enderror
                                </div>
                            </div>
                            <div class="col-md-2 col-sm-12">
                                <div class="form-group">
                                    <label for="entidad_id">Entidad</label>
                                    <select class="form-control select2 @error('entidad_id') error @enderror" wire:model.live="entidad_id" id="entidad_id">
                                        <option value="">--SELECCIONE--</option>
                                        @foreach ($entidades as $entidad)
                                            <option value="{{ $entidad->id }}" {{ old('entidad_id') == $entidad->id ? 'selected' : '' }}>{{ $entidad->nombre }}</option>
                                        @endforeach
                                    </select>
                                    @error('entidad_id') <div class="text-danger text-xs">{{ $message }}</div> @enderror
                                </div>
                            </div>
                            {{-- <div class="col-md-8 col-sm-12">
                                <div class="form-group">
                                    <label for="responsable_id">Técnico Asignado</label>
                                    <select class="form-control select2  @error('responsable_id') error @enderror"  wire:model.live="responsable_id" id="responsable_id">
                                        <option value="">--SELECCIONE--</option>
                                        @foreach ($responsables as $responsable)
                                            <option value="{{ $responsable->id }}" {{ old('responsable_id') == $responsable->id ? 'selected' : '' }}>{{ $responsable->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('responsable_id') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                                </div>
                            </div> --}}
                        {{-- </div>
                        <div class="row"> --}}
                            <div class="col-md-4">
                                <div class="form-group" >
                                        <label for="gerencia_id">Gerencia</label>
                                        <select id="gerencia_id" class="form-control select2" wire:model.live="gerencia_id" >
                                            <option value="">--SELECCIONE--</option>
                                            @foreach($gerencias as $gerencia)
                                                <option value="{{ $gerencia->id }}" @selected($gerencia_id == $gerencia->id)>
                                                    {{ $gerencia->nombre }}
                                                </option>
                                            @endforeach
                                        </select>
                                    @error('gerencia_id') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group" >
                                        <label for="unidad_id">Unidad Solicitante</label>
                                        <select id="unidad_id" class="form-control select2" wire:model.live="unidad_id" >
                                            <option value="">--SELECCIONE--</option>
                                            @foreach($unidades as $unidad)
                                                <option value="{{ $unidad->id }}" @selected($unidad_id == $unidad->id)>
                                                    {{ $unidad->nombre }}
                                                </option>
                                            @endforeach
                                        </select>
                                    @error('unidad_id') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="nuri_informe">N° NURI INFORME JUSTIFICACIÓN <span class="text-danger">(*)</span></label>
                                    <input type="text" class="form-control @error('nuri_informe') error @enderror" wire:model.live="nuri_informe" id="nuri_informe">
                                    @error('nuri_informe') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="nuri_nota_autorizacion">N° NURI NOTA AUTORIZACIÓN <span class="text-danger">(*)</span></label>
                                    <input type="text" class="form-control @error('nuri_nota_autorizacion') error @enderror" wire:model.live="nuri_nota_autorizacion" id="nuri_nota_autorizacion">
                                    @error('nuri_nota_autorizacion') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                                </div>
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <div class="form-group">
                                    <label for="objeto_contratacion">Objeto de la Contratación <span class="text-danger">(*)</span></label>
                                    <textarea name="objeto_contratacion" id="objeto_contratacion" wire:model.live="objeto_contratacion" class="form-control @error('objeto_contratacion') error @enderror" cols="30" rows="2">{{ old('objeto_contratacion') }}</textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-2 col-sm-12">
                                <div class="form-group">
                                    <label for="normativa_id">Normativa Aplicable <span class="text-danger">(*)</span></label>
                                    <select id="normativa_id" class="form-control select2 @error('normativa_id') error @enderror" wire:model.live="normativa_id">
                                        <option value="">--SELECCIONE--</option>
                                        @foreach ($normativas as $normativa)
                                            <option value="{{ $normativa->id }}" {{ old('normativa_id') == $normativa->id ? 'selected' : '' }}>{{ $normativa->nombre }}</option>
                                        @endforeach
                                    </select>
                                    @error('normativa_id') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="modalidad_id">Modalidad del Proceso <span class="text-danger">(*)</span></label>
                                    <select id="modalidad_id" class="form-control select2 @error('modalidad_id') error @enderror" wire:model.live="modalidad_id">
                                        <option value="">--SELECCIONE--</option>
                                        @foreach ($modalidades as $modalidad)
                                            <option value="{{ $modalidad->id }}" {{ old('modalidad_id') == $modalidad->id ? 'selected' : '' }}>{{ $modalidad->nombre }}</option>
                                        @endforeach
                                    </select>
                                    @error('modalidad_id') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="metodo_seleccion_id">Metodo de Selección</label>
                                    <select id="metodo_seleccion_id" class="form-control {{ $modalidad_id != 23 ? 'bg-light text-muted' : '' }} select2 @error('metodo_seleccion_id') error @enderror" wire:model.live="metodo_seleccion_id" @disabled($modalidad_id != 23)>
                                        <option value="">--SELECCIONE--</option>
                                        @foreach ($metodosSeleccion as $metodo)
                                            <option value="{{ $metodo->id }}" {{ old('metodo_seleccion_id') == $metodo->id ? 'selected' : '' }}>{{ $metodo->nombre }}</option>
                                        @endforeach
                                    </select>
                                    @error('metodo_seleccion_id') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                                </div>
                            </div>
                            <div class="col-md-2 col-sm-12">
                                <div class="form-group">
                                    <label for="tipo_contratacion_id">Tipo Contratación <span class="text-danger">(*)</span></label>
                                    <select wire:model.live="tipoContratacionId" id="tipoContratacionId"
                                            class="form-control select2">
                                        <option value="">--SELECCIONE--</option>
                                        @foreach($tiposContratacion as $tipo)
                                            <option value="{{ $tipo->id }}">{{ $tipo->nombre }}</option>
                                        @endforeach
                                    </select>
                                    @error('tipoContratacionId') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                                </div>
                            </div>

                            <div class="col-md-2 col-sm-12">
                                <div class="form-group">
                                    <label for="forma_adjudicacion_id">Forma Adjudicación <span class="text-danger">(*)</span></label>
                                    <select wire:model.live="formaAdjudicacionId" id="formaAdjudicacionId"
                                            class="form-control select2">
                                        <option value="">--SELECCIONE--</option>
                                        @foreach($formasDisponibles as $forma)
                                            <option value="{{ $forma->id }}">{{ $forma->nombre }}</option>
                                        @endforeach
                                    </select>
                                    @error('formaAdjudicacionId') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group mb-4">
                                <div class="col-12">
                                    <div class="d-flex align-items-center justify-content-start items-center mb-2">
                                        <h4 class="font-bold">ESPECIFICACIONES DE LA SOLICITUD</h4>
                                        <button type="button" wire:click="openItemModal" class="btn btn-success ml-3">Agregar</button></h3>
                                    </div>
                                    @if(session()->has('message'))
                                        <div class="mb-2 text-green-700">{{ session('message') }}</div>
                                    @endif
                                </div>
                                <div class="col-12">
                                    <table class="table table-hover" width="100%">
                                        <thead>
                                            <tr>
                                                <th class="text-center">Acciones</th>
                                                <th class="text-center">Nombre</th>
                                                <th class="text-center">Precio Referencial</th>
                                                <th class="text-center">Unidad Medida</th>
                                                <th class="text-center">Tiempo o Plazo de Entrega</th>
                                                <th class="text-center">Forma de  Entrega</th>
                                                <th class="text-center">Lugar de Entrega</th>
                                                <th class="text-center">Forma de Pago</th>
                                                <th class="text-center">Garantia</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($items as $idx => $item)
                                                <tr>
                                                    <td class="text-center">
                                                        <button type="button" wire:click="openItemModal({{ $idx }})" class="btn btn-warning btn-sm"><i class="fa fa-edit"></i></button>
                                                        <button type="button" wire:click="removeItem({{ $idx }})" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></button>
                                                    </td>
                                                    <td class="text-center">
                                                        {{ $item['nombre'] }}
                                                    </td>
                                                    <td class="text-center">
                                                        {{ $item['monto'] }}
                                                    </td>
                                                    <td class="text-center">
                                                        {{ $item['unidad'] }}
                                                    </td>
                                                    <td class="text-center">
                                                        {{ $item['tiempo_entrega'] }}
                                                    </td>
                                                    <td class="text-center">
                                                        {{ $item['forma_entrega'] }}
                                                    </td>
                                                    <td class="text-center">
                                                        {{ $item['lugar_entrega'] }}
                                                    </td>
                                                    <td class="text-center">
                                                        {{ nombreFormaPago($item['forma_pago']) }}
                                                    </td>
                                                    <td class="text-center">
                                                        {{ $item['garantia'] }}
                                                    </td>
                                                </tr>
                                            @endforeach
                                            @if(count($items) === 0)
                                                <tr>
                                                    <td colspan="9" class="text-center">No hay ítems agregados.</td>
                                                </tr>
                                            @endif
                                            <tfoot>
                                                <tr><th colspan="8" class="text-right"> <h4>PRESUPUESTO TOTAL</h4></th>
                                                    <td class="text-right">
                                                        <h4>{{ number_format($presupuesto_total,2) }}</h4>
                                                    </td>
                                                </tr>
                                            </tfoot>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="formalizacion">Formalización</label>
                                    <select id="formalizacion" class="form-control select2" wire:model.live="formalizacion">
                                        <option value="">--SELECCIONE--</option>
                                        @foreach($tiposFormalizacion as $tipo)
                                            <option value="{{ $tipo->id }}">{{ $tipo->nombre }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="codigo_pac">PAC</label>
                                    <input type="text" name="codigo_pac" id="codigo_pac" wire:model.live="codigo_pac" class="form-control @error('codigo_pac') error @enderror  {{ $modalidad_id != 22 ? 'bg-light text-muted' : '' }}" @disabled($modalidad_id != 22)>
                                    @error('codigo_pac') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                                </div>
                            </div>
                        </div>
                        <div class="text-center">
                            <button type="button" wire:click="guardarProceso" class="btn btn-primary rounded">Registrar</button>
                            <a href="{{ route('procesos-contratacion.index') }}" class="btn btn-warning rounded">Salir</a>
                        </div>
                </div>
            </div>
        </div>
    </div>
    @if($showItemModal)
        @include('livewire.procesos._modal_items')
    @endif
</div>
@section('scripts')
<script>
    document.addEventListener('livewire:initialized', function () {
        // $(".select2").select2();
        Livewire.hook('morphed', () => {
            $(".select2").select2();
        });
    })
    document.addEventListener('livewire:navigated', function () {
        $('.select2').each(function () {
            let $select = $(this);
            $select.select2();
            $select.on('change', function () {
                // El id del select será el nombre de la propiedad Livewire
                let prop = $select.attr('id');
                @this.set(prop, $select.val());
            });
        });
    });
    Livewire.on('alerta', ({ text }) => {
        Swal.fire('Correcto', text, 'success');
    });
</script>
@endsection