<div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0, 0, 0, 0.5);" role="dialog">
            <div class="modal-dialog modal-lg" >
                <div class="modal-content">
                    <div class="modal-header bg-primary">
                        <h5 class="modal-title text-white">{{ is_null($editingIndex) ? 'AGREGAR ' : 'EDITAR' }}</h5>
                        <button type="button" wire:click="$set('showItemModal', false)" class="btn-close"></button>
                    </div>
                    <div class="modal-body pr-5 pl-5">
                        <p>Los campos con <strong class="text-danger">(*)</strong> son de ingreso obligatorios</p>
                    
                        <div class="row mb-2">
                            <div class="col-12">
                                <label for="nombre">Nombre Item/Lote/Bien/Detalle Obra/Tramos/Paquetes/Servicio <span class="text-danger">(*)</span></label>
                                <input type="text" wire:model.defer="itemForm.nombre" class="form-control">
                                @error('itemForm.nombre') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="row mb-2">
                            <div class="col-md-6 col-sm-12">
                                <label for="monto">Precio Referencial <span class="text-danger">(*)</span></label>
                                <input type="number" wire:model.defer="itemForm.monto" class="form-control">
                                @error('itemForm.monto') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <label for="unidad">Unidad de Medida <span class="text-danger">(*)</span></label>
                                <input type="text" wire:model.defer="itemForm.unidad" class="form-control">
                                @error('itemForm.unidad') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="row mb-2">
                            <div class="col-md-12 col-sm-12">
                                <label for="tiempo_entrega">Tiempo o Plazo de Entrega <span class="text-danger">(*)</span> <small>(Nro. dias calendario)</small> </label>
                                <input type="number" wire:model.defer="itemForm.tiempo_entrega" class="form-control">
                                @error('itemForm.tiempo_entrega') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="row mb-2">
                            <div class="col-12">
                                <label for="forma_entrega">Forma de Entrega <span class="text-danger">(*)</span></label>
                                <input type="text" wire:model.defer="itemForm.forma_entrega" class="form-control">
                                @error('itemForm.forma_entrega') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="row mb-2">
                            <div class="col-12">
                                <label for="lugar_entrega">Lugar de Entrega <span class="text-danger">(*)</span></label>
                                <input type="text" wire:model.defer="itemForm.lugar_entrega" class="form-control">
                                @error('itemForm.lugar_entrega') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="row mb-2">
                            <div class="col-12">
                                <label for="forma_pago">Forma de Pago <span class="text-danger">(*)</span></label>
                                <select name="forma_pago" class="form-control" id="forma_pago" wire:model.defer="itemForm.forma_pago">
                                    <option value="Contado">--SELECCIONE--</option>
                                    @foreach($formasPago as $formaPago)
                                        <option value="{{ $formaPago->id }}">{{ $formaPago->nombre }}</option>
                                    @endforeach
                                </select>
                                @error('itemForm.forma_entrega') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="row mb-2">
                            <div class="col-12">
                                <label for="garantia">Garantía de Cumplimiento de contrato</label>
                                <textarea name="garantia" class="form-control" id="garantia" wire:model.defer="itemForm.garantia" cols="3" rows="2"></textarea>
                                @error('itemForm.garantia') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" wire:click="saveItem" class="btn btn-primary">Guardar</button>
                        <button type="button" wire:click="$set('showItemModal', false)" class="btn btn-secondary">Cancelar</button>
                    </div>
                </div>
            </div>
        </div>