<div>
    <!-- Modal de Seguimiento -->
<div wire:ignore.self class="modal fade" id="modalSeguimiento" tabindex="-1" aria-labelledby="modalSeguimientoLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form wire:submit="guardarSeguimiento">
        <div class="modal-header">
          <h5 class="modal-title" id="modalSeguimientoLabel">{{ $modo == 'editar' ? 'EDITAR SEGUIMIENTO' : 'AGREGAR SEGUIMIENTO' }} </h5>
          <button type="button" class="btn btn-close" data-dismiss="modal" aria-label="Cerrar"><i class="fa fa-close"></i></button>
        </div>
        <div class="modal-body">
          <p>Debe rellenar todos los campos marcados con <strong class="text-danger">(*)</strong>.</p>
          <div class="mb-3">
            <label for="fecha_seguimiento" class="form-label">Fecha de Seguimiento <span class="text-danger">(*)</span></label>
            <input wire:model="fecha_seguimiento" type="date" class="form-control @error('fecha_seguimiento') is-invalid @enderror">
            @error('fecha_seguimiento') <span class="text-danger">{{ $message }}</span> @enderror
          </div>
          <div class="mb-3">
            <label for="estado_seguimiento" class="form-label">Estado de Seguimiento <span class="text-danger">(*)</span></label>
            <select wire:model="estado_seguimiento" class="form-control @error('estado_seguimiento') is-invalid @enderror">
              <option value="">Seleccione un estado</option>
              @foreach ($estados_seguimiento as $e)
                <option value="{{ $e->id }}">{{ $e->nombre }}</option>
              @endforeach
            </select>
            @error('estado_seguimiento') <span class="text-danger">{{ $message }}</span> @enderror
          </div>
          <div class="mb-3">
            <label for="observacion" class="form-label">Observación</label>
            <textarea wire:model="observacion" class="form-control" rows="2"></textarea>
          </div>
          @if($modo == 'editar' && count($adjuntos_existentes) > 0)
            <div class="mb-3">
              <label class="form-label">Adjuntos existentes:</label>
              <ul class="list-group">
                @foreach($adjuntos_existentes as $adjunto)
                  <li class="list-group-item d-flex justify-content-between align-items-center">
                    <a href="{{ Storage::url($adjunto['ruta']) }}" target="_blank">{{ $adjunto['nombre'] }}</a>
                    <button wire:click.prevent="eliminarAdjunto({{ $adjunto['id'] }})" class="btn btn-sm btn-danger">Eliminar</button>
                  </li>
                @endforeach
              </ul>
              @error('adjuntos.*') <span class="text-danger">{{ $message }}</span> @enderror
            </div>
          @endif
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary"> {{ $modo == 'editar' ? 'Actualizar Seguimiento' : 'Guardar Seguimiento' }}</button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
        </div>
      </form>
    </div>
  </div>
</div>

</div>
