<div>
    <div wire:ignore.self class="modal fade" id="modalAsignacion" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">ASIGNAR TÉCNICO</h5>
                <button type="button" class="btn btn-close" data-dismiss="modal" aria-label="Cerrar"><i class="fa fa-close"></i></button>
            </div>

            <div class="modal-body">
                @if($actualResponsableName)
                    <div class="alert alert-warning alert-outline-warning">
                        Actualmente asignado: <strong>{{ $actualResponsableName }}</strong>
                    </div>
                @endif

                <select wire:model.live="responsable_id" class="form-control @error('responsable_id') is-invalid @enderror">
                    <option value="">Seleccione un técnico</option>
                    @foreach($tecnicos as $tecnico)
                        <option value="{{ $tecnico->id }}">{{ $tecnico->name }}</option>
                    @endforeach
                </select>
                @error('responsable_id')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
                <label for="observacion" class="form-label mt-2">Observación</label>
                <textarea wire:model.live="observacion" class="form-control @error('observacion') is-invalid @enderror" id="observacion" rows="3"></textarea>
                
                @error('observacion')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
                
            </div>

            <div class="modal-footer">
                <button wire:click="asignar" class="btn btn-primary">Asignar</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>

</div>