<!-- resources/views/reportes/usuarios.blade.php -->

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>{{ $contrato->codigo }}</title>
    {{-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-LN+7fdVzj6u52u30Kp6M/trliBMCMKTyK833zpbD+pXdCLuTusPj697FH4R/5mcr" crossorigin="anonymous"> --}}
    <link href="{{ asset('css/bootstrap.min.css') }}" rel="stylesheet">
    {{-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/js/bootstrap.bundle.min.js" integrity="sha384-ndDqU0Gzau9qJ1lfW4pNLlhNTkCfHzAVBReH9diLvGRem5+R9g2FzA8ZGN954O5Q" crossorigin="anonymous"></script> --}}
    <style>
         body { font-size: 12px; }
        .form-group {
            margin-bottom: 10px;
        }
        .row {
        display: block !important;
        clear: both;
        padding: 10px 20px;
    }
    [class^="col-"] {
        float: left;
        padding: 0 10px;
        box-sizing: border-box;
    }
    .col-md-6 {
        width: 50%;
    }
    .col-md-5 {
        width: 41.66%;
    }
    .col-md-4 {
        width: 33.33%;
    }
    .col-md-3 {
        width: 25%;
    }
    .col-md-2 {
        width: 16.66%;
    }
    .col-md-12 {
        width: 100%;
    }
        input {
            width: 100%;
            padding: 4px;
            box-sizing: border-box;
        }
    </style>
</head>
<body>
    <h2>{{ $contrato->codigo }}</h2>
    <p>Fecha: {{ date('Y-m-d') }}</p>

<div class="row">
    <div class="col-md-3">
        <div class="form-group">
            <label for="nuri">NURI <span class="text-danger">(*)</span></label>
            <input type="text" class="form-control" id="nuri" name="nuri" value="{{ $contrato->nuri }}">
        </div>
    </div>
    <div class="col-md-3">
        <div class="form-group">
            <label for="codigo_pac">Código del PAC</label>
            <input type="text" class="form-control" id="codigo_pac" name="codigo_pac" value="{{ $contrato->codigo_pac }}">
        </div>
    </div>
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="fecha_ingreso">Fecha de Ingreso <span class="text-danger">(*)</span></label>
            <input type="date" class="form-control @error('fecha_ingreso') error @enderror" id="fecha_ingreso" name="fecha_ingreso" value="{{ old('fecha_ingreso') ?? date('Y-m-d', strtotime($contrato->fecha_ingreso ?? date('Y-m-d'))) }}">
        </div>
    </div>
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="tipo_gasto_id">Inversión / Gasto Corriente <span class="text-danger">(*)</span></label>
            
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12 ">
        <div class="form-group">
            <label for="objeto_contratacion">Objeto de la Contratación <span class="text-danger">(*)</span></label>
            <textarea name="objeto_contratacion" id="objeto_contratacion" class="form-control @error('objeto_contratacion') error @enderror" cols="30" rows="2">{{ old('objeto_contratacion') ?? $contrato->objeto_contratacion }}</textarea>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-4 ">
        <div class="form-group">
            <label for="normativa_id">Normativa Aplicable <span class="text-danger">(*)</span></label>
            <input type="text" name="normativa_id" id="normativa_id" class="form-control" value="{{ $contrato->normativa->nombre }}">
        </div>
    </div>
    <div class="col-md-4 ">
        <div class="form-group">
            <label for="modalidad_id">Modalidad del Proceso <span class="text-danger">(*)</span></label>
            <input type="text" name="modalidad_id" id="modalidad_id" class="form-control" value="{{ $contrato->modalidad->nombre }}">
        </div>
    </div>
    <div class="col-md-4 ">
        <div class="form-group">
            <label for="precio_referencial">Precio Referencial <span class="text-danger">(*)</span></label>
            <input type="text" name="precio_referencial" id="precio_referencial" class="form-control text-right" value="{{ number_format($contrato->precio_referencial,2) }}">
        </div>
    </div>
</div>
<hr>
<div class="row">
    <div class="col-md-2 ">
        <div class="form-group">
            <label for="fuente_organismo">Fuente / Organismo</label>
            <input type="number" name="fuente_organismo" id="fuente_organismo" class="form-control @error('fuente_organismo') error @enderror" value="{{ old('fuente_organismo') ?? $contrato->fuente_organismo }}">
        </div>
    </div>
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="numero_certificacion">N° Certificación</label>
            <input type="number" name="numero_certificacion" id="numero_certificacion" class="form-control @error('numero_certificacion') error @enderror" value="{{ old('numero_certificacion') ?? $contrato->numero_certificacion }}">
        </div>
    </div>

    <div class="col-md-2 ">
        <div class="form-group">
            <label for="fecha_autorizacion_inicio_proceso">Fecha Autorización Incio Proceso</label>
            <input type="date" name="fecha_autorizacion_inicio_proceso" id="fecha_autorizacion_inicio_proceso" class="form-control @error('fecha_autorizacion_inicio_proceso') error @enderror" value="{{ old('fecha_autorizacion_inicio_proceso') ?? $contrato->fecha_autorizacion_inicio_proceso ?? '' }}">
        </div>
    </div>
    <div class="col-md-2 ">
        <div class="form-group">
            <label for="nro_resolucion_autorizacion">N° Resolución de Autorización</label>
            <input type="number" name="nro_resolucion_autorizacion" id="nro_resolucion_autorizacion" class="form-control @error('nro_resolucion_autorizacion') error @enderror" value="{{ old('nro_resolucion_autorizacion') ?? $contrato->nro_resolucion_autorizacion }}">
        </div>
    </div>
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="fecha_resolucion_autorizacion">Fecha de Resolución de Autorización</label>
            <input type="date" name="fecha_resolucion_autorizacion" id="fecha_resolucion_autorizacion" class="form-control @error('fecha_resolucion_autorizacion') error @enderror" value="{{ old('fecha_resolucion_autorizacion') ?? $contrato->fecha_resolucion_autorizacion ?? '' }}">
        </div>
    </div>
</div>
<hr>
<div class="row">
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="fecha_carta_adjudicacion">Fecha Elaboración carta de Adjudicación</label>
            <input type="date" name="fecha_carta_adjudicacion" id="fecha_carta_adjudicacion" class="form-control @error('fecha_carta_adjudicacion') error @enderror" value="{{ old('fecha_carta_adjudicacion') ?? $contrato->fecha_carta_adjudicacion ?? '' }}">
        </div>
    </div>
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="fecha_notificacion_adjudicacion">Fecha Notificación carta de Adjudicación</label>
            <input type="date" name="fecha_notificacion_adjudicacion" id="fecha_notificacion_adjudicacion" class="form-control @error('fecha_notificacion_adjudicacion') error @enderror" value="{{ old('fecha_notificacion_adjudicacion') ?? $contrato->fecha_notificacion_adjudicacion ?? '' }}">
        </div>
    </div>
    <div class="col-md-2 ">
        <div class="form-group">
            <label for="monto_adjudicado">Monto Adjudicado (Bs)</label>
            <input type="number" step="0.01" name="monto_adjudicado" id="monto_adjudicado" class="form-control @error('monto_adjudicado') error @enderror" value="{{ old('monto_adjudicado') ?? $contrato->monto_adjudicado }}">
        </div>
    </div>
    <div class="col-md-4 ">
        <div class="form-group">
            <label for="empresa_adjudicada_id">Empresa Adjudicada</label>
            <input type="text" class="form-control" id="empresa_adjudicada_id" name="empresa_adjudicada_id" value="{{ $contrato->empresaAdjudicada->nombre}}">
        </div>
    </div>
</div>
<hr>
<div class="row">
    <div class="col-md-2 ">
        <div class="form-group">
            <label for="fecha_remision_juridica">Fecha de Remisión Jurídica</label>
            <input type="date" name="fecha_remision_juridica" id="fecha_remision_juridica" class="form-control @error('fecha_remision_juridica') error @enderror " value="{{ old('fecha_remision_juridica') ?? $contrato->fecha_remision_juridica ?? '' }}">
        </div>
    </div>
    <div class="col-md-2 ">
        <div class="form-group">
            <label for="fecha_retorno_juridica">Fecha de Retorno Jurídica</label>
            <input type="date" name="fecha_retorno_juridica" id="fecha_retorno_juridica" class="form-control @error('fecha_retorno_juridica') error @enderror" value="{{ old('fecha_retorno_juridica') ?? $contrato->fecha_retorno_juridica ?? '' }}">
        </div>
    </div>

    <div class="col-md-4 ">
        <div class="form-group">
            <label for="tipo_contrato">Contrato - Orden de Compra / Servicio</label>
            <input type="text" name="tipo_contrato" id="tipo_contrato" class="form-control @error('tipo_contrato') error @enderror" value="{{ old('tipo_contrato') ?? $contrato->tipo_contrato ?? '' }}">
        </div>
    </div>
    <div class="col-md-4 ">
        <div class="form-group">
            <label for="empresa_contratada_id">Empresa Contratada</label>
            <input type="text" class="form-control" id="empresa_contratada_id" name="empresa_contratada_id" value="{{ $contrato->empresaContratada->nombre }}">
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-2 ">
        <div class="form-group">
            <label for="fecha_contrato">Fecha de Contrato</label>
            <input type="date" name="fecha_contrato" id="fecha_contrato" class="form-control @error('fecha_contrato') error @enderror" value="{{ old('fecha_contrato') ?? $contrato->fecha_contrato ?? '' }}">
        </div>
    </div>
    <div class="col-md-2 ">
        <div class="form-group">
            <label for="monto_contrato">Monto del Contrato</label>
            <input type="number" step="0.01" name="monto_contrato" id="monto_contrato" class="form-control @error('monto_contrato') error @enderror" value="{{ old('monto_contrato') ?? $contrato->monto_contrato }}">
        </div>
    </div>
</div>
<hr>
<div class="row">
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="plazo_entrega">Plazo de Entrega</label>
            <input type="text" name="plazo_entrega" id="plazo_entrega" class="form-control @error('plazo_entrega') error @enderror" value="{{ old('plazo_entrega') ?? $contrato->plazo_entrega }}">
        </div>
    </div>
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="fecha_estimada_entrega">Fecha estimada de entrega</label>
            <input type="date" name="fecha_estimada_entrega" id="fecha_estimada_entrega" class="form-control @error('fecha_estimada_entrega') error @enderror" value="{{ old('fecha_estimada_entrega') ?? $contrato->fecha_estimada_entrega ?? '' }}">
        </div>
    </div>
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="cuce">CUCE</label>
            <input type="text" name="cuce" id="cuce" class="form-control @error('cuce') error @enderror" value="{{ old('cuce') ?? $contrato->cuce }}">
        </div>
    </div>
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="registro_contraloria">Registro Contraloria</label>
            <input type="text" name="registro_contraloria" id="registro_contraloria" class="form-control @error('registro_contraloria') error @enderror" value="{{ old('registro_contraloria') ?? $contrato->registro_contraloria }}">
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="fecha_informe_conformidad">Fecha informe conformidad</label>
            <input type="date" name="fecha_informe_conformidad" id="fecha_informe_conformidad" class="form-control @error('fecha_informe_conformidad') error @enderror" value="{{ old('fecha_informe_conformidad') ?? $contrato->fecha_informe_conformidad ?? '' }}">
        </div>
    </div>
    <div class="col-md-3 ">
        <div class="form-group">
            <label for="fecha_registro_sicoes">Fecha registro sicoes</label>
            <input type="date" name="fecha_registro_sicoes" id="fecha_registro_sicoes" class="form-control @error('fecha_registro_sicoes') error @enderror" value="{{ old('fecha_registro_sicoes') ?? $contrato->fecha_registro_sicoes ?? '' }}">
        </div>
    </div>
    <div class="col-md-6 ">
        <div class="form-group">
            <label for="situacion_proceso">Situación del Proceso</label>
            <input type="text" name="situacion_proceso" id="situacion_proceso" class="form-control @error('situacion_proceso') error @enderror" value="{{ old('situacion_proceso') ?? $contrato->situacion_proceso ?? '' }}">
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-4 ">
        <div class="form-group">
            <label for="fecha_resimision_pago">Fecha de Resimisión de Pago</label>
            <input type="date" name="fecha_resimision_pago" id="fecha_resimision_pago" class="form-control @error('fecha_remision_pago') error @enderror" value="{{ old('fecha_resimision_pago') ?? $contrato->fecha_resimision_pago ?? '' }}">
        </div>
    </div>
    <div class="col-md-4 ">
        <div class="form-group">
            <label for="recurrentes">Recurrentes</label> <br>

        </div>
    </div>
    <div class="col-md-4 ">
        <div class="form-group">
            <label for="tipo_adjunto_id">Tipo de Adjunto</label>

        </div>
    </div>
    
</div>
<div class="seccion">
        <h2>Seguimientos</h2>
        @foreach($contrato->seguimientos as $seguimiento)
            <h4>Seguimiento del {{ \Carbon\Carbon::parse($seguimiento->fecha_seguimiento)->format('d/m/Y') }}</h4>
            <p>{{ $seguimiento->observacion }}</p>

            @foreach($seguimiento->adjuntos as $adjunto)
                @if(Str::endsWith($adjunto->archivo, ['jpg', 'jpeg', 'png', 'webp']))
                //agregar un salto de pagina
                <div style="page-break-after: always;"></div>
                    <img src="{{ $adjunto->url }}" alt="Adjunto" style="max-width: 100%; height: auto; margin-bottom: 10px;">
                @elseif(Str::endsWith($adjunto->archivo, ['pdf']))
                <div style="page-break-after: always;"></div>
                    <embed src="{{ $adjunto->url }}" type="application/pdf" width="100%" height="600px" />
                @endif
            @endforeach
        @endforeach
    </div>
</body>
</html>
