@extends('layouts.app')
@section('titulo','Editar Contrato')
@section('content')
<div class="row page-titles mx-0 mb-2">
    <div class="col-sm-6 p-md-0">
        <div class="welcome-text">
            <h4>Editar Contrato</h4>
            <span class="ml-1">Modificar los datos de un contrato</span>
        </div>
    </div>
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Contratos</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Ver Todos</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Editar Contrato</a></li>
        </ol>
    </div>
</div>
<!-- row -->
<div class="row">
    <div class="col-xl-12 col-xxl-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Datos Generales</h4>
                <h3 class="text-primary">{{ $contrato->codigo }}</h3>
            </div>
            <div class="card-body">
                {!! Form::model($contrato,['route'=>['contratos.update',$contrato->id],'method'=>'PUT','class'=>'form-horizontal','id'=>'formContrato']) !!}
                    @include('contratos._form',['texto' => 'Actualizar','color'=>'success'])
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>
@include('contratos._modal_empresa')
@endsection
@section('scripts')
    <script src="{{ asset('assets/js/empresas.js') }}"></script>
    <script>
         $(".select2").select2();
    </script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const btnActualizar = document.getElementById('btnGuardarContrato');
    const form = document.getElementById('formContrato');
    const responsableField = document.getElementById('responsable_id');

    btnActualizar.addEventListener('click', function (e) {
        e.preventDefault(); // <- MUY IMPORTANTE

        const actualId = responsableField.value;
        const originalId = responsableField.dataset.original;
        console.log('Actual ID:', actualId);
        console.log('Original ID:', originalId);
        // Evitamos enviar el formulario antes de tiempo
        if (actualId !== originalId) {
            if (actualId) {
                Swal.fire({
                    title: '¿Asignar nuevo técnico?',
                    text: "Se cambiará el técnico asignado al contrato.",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Sí, asignar',
                    cancelButtonText: 'Cancelar',
                    allowOutsideClick: false,
                    allowEscapeKey: false,
                    backdrop: true
                }).then((result) => {
                    if (result.isConfirmed) {
                        responsableField.value = actualId;
                        form.submit();
                    } else {
                        responsableField.value = originalId;
                    }
                });
            } else {
                Swal.fire({
                    title: '¿Quitar técnico asignado?',
                    text: "El contrato quedará sin técnico asignado.",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Sí, quitar',
                    cancelButtonText: 'Cancelar',
                    allowOutsideClick: false,
                    allowEscapeKey: false,
                    backdrop: true
                }).then((result) => {
                    if (result.isConfirmed) {
                        form.submit();
                    } else {
                        responsableField.value = originalId;
                    }
                });
            }
        } else {
            form.submit();
        }
    });
});
</script>

@endsection