@extends('layouts.app')
@section('titulo','Asignaciones Registradas')
@section('content')
<div class="row page-titles mx-0 mb-2">
    <div class="col-sm-6 p-md-0">
        <div class="welcome-text">
            <h4>Asignaciones Registradas</h4>
            <span class="ml-1">Listado de todas los Asignaciones registradas a la fecha</span>
        </div>
    </div>
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Asignaciones</a></li>
        </ol>
    </div>
</div>
@livewire('asignaciones-component')

{{-- <div class="row">
    <div class="col-xl-12 col-xxl-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Listado de asignaciones registradas</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover" id="datos">
                        <thead>
                            <tr>
                                <th class="text-center">Acciones</th>
                                <th class="text-center">Contrato</th>
                                <th class="text-center">Responsable</th>
                                <th class="text-center">Observación</th>
                                <th class="text-center">Fecha de Asignación</th>
                                <th class="text-center">Estado</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($asignaciones as $asignacion)
                                <tr>
                                    <td class="text-center">
                                        <a href="javascript:void(0);" 
                                            class="btn btn-sm btn-outline-danger delete-btn"
                                            data-id="{{ $asignacion->id }}" 
                                            title="Eliminar Asignación">
                                            <i class="fa fa-trash"></i>
                                        </a>
                                    </td>
                                    <td class="text-center">{{ $asignacion->contrato->codigo }}</td>
                                    <td class="text-center">{{ $asignacion->responsable->name }}</td>
                                    <td class="text-center">{{ $asignacion->observacion }}</td>
                                    <td class="text-center">{{ date('d/m/Y H:i', strtotime($asignacion->created_at)) }}</td>
                                    <td class="text-center">
                                        @if($asignacion->trashed())
                                            <span class="badge badge-danger">Eliminado</span>
                                        @else
                                            <span class="badge badge-success">Activo</span>
                                        @endif
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<form id="delete-form" method="POST" style="display:none;" >
    @csrf
    @method('DELETE')
</form> --}}
@endsection
{{-- @section('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            document.querySelectorAll('.delete-btn').forEach(button => {
                button.addEventListener('click', function () {
                    const itemId = this.dataset.id;
    
                    Swal.fire({
                        title: '¿Está seguro de eliminar la asignación?',
                        text: "Esta acción no se puede deshacer.",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: "#3085d6",
                        cancelButtonColor: "#d33",
                        confirmButtonText: 'Sí, eliminar',
                        cancelButtonText: 'Cancelar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            const form = document.getElementById('delete-form');
                            form.action = baseUrl + `/asignaciones/${itemId}/eliminar`; // Asegúrate que coincida con tu ruta
                            form.submit();
                        }
                    });
                });
            });
        });
    </script>
@endsection --}}
