@extends('layouts.app')
@section('title','Usuarios')
@section('content')
<div class="page-header">
    <div class="page-block">
        <div class="row align-items-center">
            <div class="col-md-12">
                <div class="page-header-title">
                    <h5>Usuarios</h5>
                </div>
                <ul class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('home') }}"><i class="feather icon-home"></i></a></li>
                    <li class="breadcrumb-item"><a href="#!">Configuración</a></li>
                    <li class="breadcrumb-item"><a href="#!">Listado de usuarios</a></li>
                </ul>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="d-flex align-items-center justify-content-between">
                    <h5>Listado de Usuarios</h5>
                    @can('users.create')<a href="{{ route('users.create') }}" class="btn btn-primary btn-round mr-2">Agregar Nuevo</a>@endcan
                </div>
            </div>
            <div class="card-body table-border-style">
                <div class="table-responsive">
                    <table width="100%" id="datos" class="table table-hover table-sm">
                        <thead>
                            <tr>
                                <th class="text-center">Acciones</th>
                                <th class="text-center">Nombre Completo</th>
                                <th class="text-center">Nombre de Usuario</th>
                                <th class="text-center">Correo</th>
                                <th class="text-center">Rol Asignado</th>
                                <th class="text-center">Unidad RRHH</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($users as $user)
                                {{-- @if($user->id != 1 && $user->id != auth()->user()->id) --}}
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center justify-content-center">
                                                @can('users.edit')
                                                    <button class="btn"><a href="{{route('users.edit',$user->id)}}" title="Modificar datos"><i class="fas fa-edit"></i></a></button>
                                                @endcan
                                                @can('users.destroy')
                                                    <button class="btn "><a href="{{route('users.destroy',$user->id)}}"  title="Eliminar Registro" onclick="return confirm('¿Está seguro que desea eliminar al USUARIO?');"><i class="fas fa-trash-alt text-danger"></i></a></button>
                                                @endcan
                                            </div>
                                        </td>
                                        <td>
                                            {{$user->name}} <br>
                                            <strong>{{$user->cargo}}</strong>
                                        </td>
                                        <td class="text-center">{{$user->username}}</td>
                                        <td class="text-center">{{$user->email}}</td>
                                        <td class="text-center">
                                            @foreach ($user->roles as $rol )
                                                <strong>{{$rol->name}}</strong>
                                            @endforeach
                                        </td>
                                        <td class="text-center">@if($user->unidad_rrhh != null ){{$user->unidad_rrhh}} @endif</td>
                                        
                                    </tr>
                                {{-- @endif --}}
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
</div>
@endsection
@section('scripts')
 <script src="{{asset('assets/js/tablas/basica.js')}}"></script>
@endsection