<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('contratos_juridicas', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('contrato_id')->nullable();
            $table->date('fecha_remision_juridica')->nullable();
            $table->date('fecha_retorno_juridica')->nullable();
            $table->string('tipo_contrato');
            $table->date('fecha_contrato')->nullable();
            $table->decimal('monto_contrato',10,2)->nullable();
            $table->unsignedBigInteger('empresa_contratada_id')->nullable();
            $table->string('plazo_entrega')->nullable();
            $table->date('fecha_estimada_entrega')->nullable();
            $table->timestamps();
            $table->softDeletes();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();
            $table->foreign('contrato_id')->references('id')->on('contratos')->onDelete('cascade');
            $table->foreign('empresa_contratada_id')->references('id')->on('empresas');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contratos_juridicas');
    }
};
