<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Wildside\Userstamps\Userstamps;

class SeguimientoAdjunto extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory, SoftDeletes, Userstamps;

    protected $fillable = [
        'seguimiento_id',
        'archivo',
        'nombre_original',
    ];

    public function seguimiento()
    {
        return $this->belongsTo(Seguimiento::class);
    }

    public function getUrlAttribute()
    {
        return asset('storage/' . $this->archivo);
    }
}
