<?php

namespace App\Models;

use Wildside\Userstamps\Userstamps;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Seguimiento extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use HasFactory, SoftDeletes, Userstamps;

    protected $fillable = [
        'proceso_id',
        'fecha_seguimiento',
        'observacion',
        'estado_id',
    ];
    public function proceso()
    {
        return $this->belongsTo(Proceso::class);
    }
    public function adjuntos()
    {
        return $this->hasMany(SeguimientoAdjunto::class);
    }
    
    public function estado()
    {
        return $this->belongsTo(Parametro::class);
    }
    public function tecnico()
    {
        return $this->belongsTo(User::class, 'created_by', 'id');
    }
}
