<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use App\Models\ServiceEmpleado;
use Illuminate\Validation\Rule;
use App\Http\Requests\UserRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Hash;
use YoHang88\LetterAvatar\LetterAvatar;
use RealRashid\SweetAlert\Facades\Alert;

class UserController extends Controller
{
    private $roles;
    private $unidades;
    public function __construct()
    {
        $this->middleware('auth');

    }
    public function index()
    {
        if(auth()->user()->unidad_id != null && auth()->user()->rol[0]->id != 7){
            $users=User::where('unidad_id',auth()->user()->unidad_id)->with('unidad')->get();
        }else{
            $users=User::with('unidad')->get();
        }

        return view('admin.users.index',compact('users'));
    }


    
    public function edit(User $user)
    {
        //dd($user);
        $this->datos_formulario();
        $empleadosRRHH=ServiceEmpleado::all();
        
        $roles=$this->roles;
        $unidades=$this->unidades;
        $empleados=$empleadosRRHH;

        return view('admin.users.edit',compact('user','roles','unidades','empleados'));
    }

    public function update(UserRequest $request, User $user)
    {
        $user->name = $request->name;
        $user->username = $request->username;
        $user->empleado_id = $request->empleado_id;
        $user->email = $request->email;
        $user->cargo = $request->cargo;
        $user->area_rrhh = $request->area_rrhh;
        $user->entidad = $request->entidad;
        $user->area_rrhh_id = $request->area_rrhh_id;
        $user->unidad_rrhh = $request->unidad_rrhh;
        $user->empleado_ci = $request->empleado_ci;
        $user->unidad_id = $request->unidad_id;
        
        $path=public_path()."/assets/img/avatars/".$user->id.'.jpg';
        if(isset($request->password)){
            $user->password = Hash::make($request->password);
        }
        
        if (!file_exists($path)){
            $avatar = new LetterAvatar($request->name,'circle', 64);
            $avatar->saveAs($path, LetterAvatar::MIME_TYPE_JPEG);
        }
                
        $user->save();
        //actualice los roles
        $user->roles()->sync($request->role_id);
        
        Alert::success('Datos actualizados correctamente!');
        return redirect()->route('users.index');
    }

    public function update_profile(Request $request, User $user){
        $request->validate([
            'name' => 'required',
            'avatar' => 'image|mimes:jpeg,png,jpg,gif,svg',
            'username' => [
                'required',
                'string',
                'max:255',
                Rule::unique('users')->ignore($user->id),
            ],
        ],[
            'username.unique' => 'El nombre de usuario ya existe',
            'username.required' => 'El nombre de usuario es obligatorio',
            'name.required' => 'El nombre es obligatorio',
        ]);

        $nombre_usuario=$user->username;
        $user->name=$request->name;
        $user->username=$request->username;   
        
        $file_foto=$request->file('avatar');
        if($file_foto != null){
            $direccion=public_path()."/assets/img/avatars/";
            $fullPath=public_path().'/assets/img/avatars/'.$user->avatar;
            File::delete($fullPath);
            $filename=$file_foto->getClientOriginalName();
            $file_foto->move($direccion, $filename);
            $user->avatar=$filename;
        }else{
            $path=public_path()."/assets/img/avatars/".$user->id.'.jpg';
            if (!file_exists($path)){
                $avatar = new LetterAvatar($request->name,'circle', 64);
                $avatar->saveAs($path, LetterAvatar::MIME_TYPE_JPEG);
            }
            $user->avatar=$user->id.'.jpg';
        }
        $user->save();
        if($nombre_usuario != $user->username){
            Auth::logout();
            $request->session()->invalidate();
            $request->session()->regenerateToken();
            Alert::success('Su Nombre de Usuario ha sido actualizado!', 'Por favor, ingrese nuevamente con su nuevo nombre de usuario.');
            return redirect()->route('login');
        }
        Alert::success('Datos actualizados correctamente!');
        return redirect()->back();
    }

    public function update_email(Request $request){
        $request->validate([
            'email' => 'required',
        ],[
            'email.required' => 'El correo es obligatorio',
        ]);
        $user=User::find(auth()->user()->id);
        $user->email=$request->email;
        $user->email_verified_at = date('Y-m-d H:i:s');
        $user->save();

        Alert::success('Correo actualizado correctamente!');

        return redirect()->back();
    }
}
