<?php

namespace Sedem\ManualUsuario\Providers;

use Illuminate\Support\ServiceProvider;
use Sedem\ManualUsuario\Console\InstallManualCommand;

class ManualUsuarioServiceProvider extends ServiceProvider
{
    public function register()
    {
        $this->mergeConfigFrom(
            __DIR__.'/../../config/manualusuario.php',
            'manualusuario'
        );
    }

    public function boot()
    {
        $this->loadRoutesFrom(__DIR__.'/../../routes/web.php');
        $this->loadViewsFrom(__DIR__.'/../../resources/views', 'manualusuario');

        $this->publishes([
            __DIR__.'/../../config/manualusuario.php' => config_path('manualusuario.php'),
        ], 'manualusuario-config');

        $this->publishes([
            __DIR__.'/../../resources/views' => resource_path('views/vendor/manualusuario'),
        ], 'manualusuario-views');

        $this->publishes([
            __DIR__.'/../../database/migrations' => database_path('migrations'),
        ], 'manualusuario-migrations');

        if ($this->app->runningInConsole()) {
            $this->commands([
                InstallManualCommand::class,
            ]);
        }
    }
}
