<?php

namespace Sedem\ManualUsuario\Models;

use Illuminate\Database\Eloquent\Model;

class ManualSection extends Model
{
    protected $fillable = ['manual_id', 'parent_id', 'titulo', 'orden'];

    public function manual()
    {
        return $this->belongsTo(Manual::class);
    }

    public function children()
    {
        return $this->hasMany(ManualSection::class, 'parent_id')->with('children');
    }

    public function parent()
    {
        return $this->belongsTo(ManualSection::class, 'parent_id');
    }

    public function content()
    {
        return $this->hasOne(ManualContent::class, 'section_id');
    }
}
