<?php

namespace Sedem\ManualUsuario\Http\Controllers;

use App\Http\Controllers\Controller;
use Sedem\ManualUsuario\Models\Manual;
use Sedem\ManualUsuario\Models\ManualSection;
use Barryvdh\Snappy\Facades\SnappyPdf as PDF;

class ManualController extends Controller
{
    public function index()
    {
        $manual = Manual::with('sections.children')->first();
        return view('manualusuario::index', compact('manual'));
    }

    public function show($id)
    {
        $section = ManualSection::with('content')->findOrFail($id);
        return view('manualusuario::show', compact('section'));
    }

    public function exportPdf($manualId)
    {
        $manual = Manual::with('sections.children')->findOrFail($manualId);

        $pdf = PDF::loadView('manualusuario::pdf.manual', compact('manual'))
                ->setOption('enable-local-file-access', true)
                ->setOption('encoding', 'UTF-8')
                ->setOption('margin-top', 10)
                ->setOption('margin-bottom', 10)
                ->setOption('margin-left', 10)
                ->setOption('margin-right', 10);

        return $pdf->download('manual_'.$manual->id.'.pdf');
    }
}
