<?php

namespace Sedem\ManualUsuario\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Sedem\ManualUsuario\Models\Manual;
use Sedem\ManualUsuario\Models\ManualSection;

class ManualSectionAdminController extends Controller
{
     public function index()
    {
        $sections = ManualSection::all();
        return view('manualusuario::admin.sections.index', compact('sections'));
    }

    public function create()
    {
        $sections = ManualSection::all();
        $manuals=Manual::all();
        $section = new ManualSection();
        return view('manualusuario::admin.sections.create',compact('sections','manuals','section'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'titulo' => 'required|string|max:255',
            'orden' => 'required|integer',
        ]);
        ManualSection::create($request->all());
        return redirect()->route('admin.manual.sections.index')->with('success','Manual creado correctamente');
    }

    public function edit(ManualSection $section)
    {
        $sections = ManualSection::all();
        $manuals=Manual::all();
        return view('manualusuario::admin.sections.edit', compact('section','sections','manuals'));
    }

    public function update(Request $request, ManualSection $section)
    {
        $request->validate([
            'titulo' => 'required|string|max:255',
            'orden' => 'required|integer',
        ]);
        $section->update($request->all());
        return redirect()->route('admin.manual.sections.index')->with('success','Manual actualizado');
    }

    public function destroy(ManualSection $section)
    {
        $section->delete();
        return redirect()->route('admin.manual.sections.index')->with('success','Manual eliminado');
    }
}
