<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>{{ $manual->titulo }}</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; line-height: 1.4; }
        h1,h2,h3,h4,h5 { margin-top: 20px; }
        img { max-width: 100%; height: auto; }
        ol, ul { margin-left: 1.5rem; }
    </style>
</head>
<body>
    <h1>{{ $manual->titulo }}</h1>

    @php
    function renderSectionsPdf($sections, $level = 2) {
        foreach ($sections as $section) {
            echo '<h'.$level.'>'.$section->titulo.'</h'.$level.'>';
            echo $section->content?->contenido ?? ''; 
            // if ($section->children->count()) {
            //     renderSectionsPdf($section->children, min($level+1, 6));
            // }
        }
    }
    @endphp

    {!! renderSectionsPdf($manual->sections) !!}
</body>
</html>
