<!DOCTYPE html>
<html>
<head>
    <title>{{ $manual->nombre ?? 'Manual de Usuario' }} - @yield('title')</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background: #f8f9fa; }
        .sidebar {
            min-height: 100vh;
            background: #12283e;
            color: white;
        }
        .sidebar a {
            color: #ddd;
            display: block;
            padding: 10px;
            text-decoration: none;
        }
        .sidebar a:hover { background: #00b6bf; color: #fff; }
        .sidebar .submenu { padding-left: 20px; }
        .admin-menu a { margin-right: 5px; }
        .contenido-manual figure.image {
            display: flex;
            justify-content: center;
            margin: 1rem 0;
        }
         figure.image img{
            width: 100%;
            height: auto;
        }

        .contenido-manual figure.image img {
            max-width: 100%;
            height: auto;
            border-radius: 8px;
        }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-md-3 sidebar p-3">
            <div class="d-flex flex-column justify-content-between">
                <div>
                    <h4 class="text-white">{{ $manual->nombre ?? 'Manual' }}</h4>
                    <ul class="list-unstyled">
                        @foreach($manual->sections->where('parent_id', null)->sortBy('orden') as $menu)
                            <li>
                                <a href="{{ route('manual.show', $menu->id) }}">{{ $menu->titulo }}</a>
                                @if($menu->children->count())
                                    <ul class="submenu list-unstyled">
                                        @foreach($menu->children->sortBy('orden') as $submenu)
                                            <li>
                                                <a href="{{ route('manual.show', $submenu->id) }}">
                                                    {{ $submenu->titulo }}
                                                </a>
                                                @if($menu->children->count())
                                                    <ul class="submenu list-unstyled">
                                                        @foreach($submenu->children->sortBy('orden') as $subsubmenu)
                                                            <li>
                                                                <a href="{{ route('manual.show', $subsubmenu->id) }}">
                                                                    {{ $subsubmenu->titulo }}
                                                                </a>
                                                            </li>
                                                        @endforeach
                                                    </ul>
                                                @endif
                                            </li>
                                        @endforeach
                                    </ul>
                                @endif
                            </li>
                        @endforeach
                        {{-- @foreach($manual->sections as $section)
                            <li class="list-group-item">
                                <a href="#section-{{ $section->id }}">{{ $section->titulo }}</a>

                                @if($section->children->count())
                                    <ul class="list-group mt-2 ms-3">
                                        @foreach($section->children as $child)
                                            <li class="list-group-item">
                                                <a href="#section-{{ $child->id }}">{{ $child->titulo }}</a>
                                            </li>
                                        @endforeach
                                    </ul>
                                @endif
                            </li>
                        @endforeach --}}
                    </ul>
                </div>
                <div><a href="{{ route('home') }}">Volver Al Sistema</a></div>
                <a href="{{ route('admin.manual.pdf', $manual->id) }}" class="btn btn-primary">Descargar PDF</a>

            </div>
        </div>

        <!-- Contenido -->
        <div class="col-md-9 p-4">
            <!-- Menú de administración solo para admins o permisos -->
            {{-- @can('manage manuals') --}}
            <div class="admin-menu mb-3">
                <a href="{{ route('admin.manual.manuals.index') }}" class="btn btn-primary btn-sm">Administrar Manual</a>
                <a href="{{ route('admin.manual.sections.index') }}" class="btn btn-secondary btn-sm">Secciones</a>
                <a href="{{ route('admin.manual.contents.index') }}" class="btn btn-info btn-sm">Contenidos</a>
            </div>
            {{-- @endcan --}}

            <!-- Contenido principal -->
            @yield('content')
        </div>
    </div>
</div>
</body>
</html>
