@extends('manualusuario::admin.layout')

@section('title', 'Lista de Secciones')

@section('content')
<div class="d-flex justify-content-between mb-3">
    <h2>Secciones</h2>
    <a href="{{ route('admin.manual.sections.create') }}" class="btn btn-primary">Nueva Sección</a>
</div>

<table class="table table-bordered">
    <thead>
        <tr>
            <th>ID</th>
            <th>Nombre</th>
            <th>Titulo</th>
            <th>Orden</th>
            <th>Acciones</th>
        </tr>
    </thead>
    <tbody>
        @foreach($sections as $section)
        <tr>
            <td>{{ $section->id }}</td>
            <td>{{ $section->manual->nombre }}</td>
            <td>{{ $section->titulo }}</td>
            <td>{{ $section->orden }}</td>
            <td>
                <a href="{{ route('admin.manual.sections.edit', $section) }}" class="btn btn-sm btn-warning">Editar</a>
                <form method="POST" action="{{ route('admin.manual.sections.destroy', $section) }}" class="d-inline">
                    @csrf @method('DELETE')
                    <button class="btn btn-sm btn-danger" onclick="return confirm('¿Eliminar manual?')">Eliminar</button>
                </form>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection
