@extends('manualusuario::admin.layout')

@section('title', 'Lista de Manuales')

@section('content')
<div class="d-flex justify-content-between mb-3">
    <h2>Manuales</h2>
    <a href="{{ route('admin.manual.manuals.create') }}" class="btn btn-primary">Nuevo Manual</a>
</div>

<table class="table table-bordered">
    <thead>
        <tr>
            <th>ID</th><th>Nombre</th><th>Acciones</th>
        </tr>
    </thead>
    <tbody>
        @foreach($manuals as $manual)
        <tr>
            <td>{{ $manual->id }}</td>
            <td>{{ $manual->nombre }}</td>
            <td>
                <a href="{{ route('admin.manual.manuals.edit', $manual) }}" class="btn btn-sm btn-warning">Editar</a>
                <form method="POST" action="{{ route('admin.manual.manuals.destroy', $manual) }}" class="d-inline">
                    @csrf @method('DELETE')
                    <button class="btn btn-sm btn-danger" onclick="return confirm('¿Eliminar manual?')">Eliminar</button>
                </form>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection
