@extends('manualusuario::admin.layout')

@section('title', 'Lista de Contenidos')

@section('content')
<div class="d-flex justify-content-between mb-3">
    <h2>Contenidos</h2>
    <a href="{{ route('admin.manual.contents.create') }}" class="btn btn-primary">Nuevo Contenido</a>
</div>

<table class="table table-bordered">
    <thead>
        <tr>
            <th>ID</th>
            <th>Sección</th>
            <th>Titulo</th>
            <th>Contenido</th>
            <th>Acciones</th>
        </tr>
    </thead>
    <tbody>
        @foreach($contents as $content)
        <tr>
            <td>{{ $content->id }}</td>
            <td>{{ $content->section->titulo }}</td>
            <td>{{ $content->titulo }}</td>
            <td>{!!  $content->contenido !!}</td>
            <td>
                <a href="{{ route('admin.manual.contents.edit', $content) }}" class="btn btn-sm btn-warning">Editar</a>
                <form method="POST" action="{{ route('admin.manual.contents.destroy', $content) }}" class="d-inline">
                    @csrf @method('DELETE')
                    <button class="btn btn-sm btn-danger" onclick="return confirm('¿Eliminar content?')">Eliminar</button>
                </form>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection
