@extends('manualusuario::admin.layout')
@section('title','Editar Contenido')

@section('content')
<h2>Editar Contenido</h2>
<form method="POST" action="{{ route('admin.manual.contents.update', $content) }}">
    @csrf
    @method('PUT')
    @include('manualusuario::admin.contents._form')
</form>

<script src="https://cdn.ckeditor.com/ckeditor5/41.2.1/classic/ckeditor.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
        const editores = document.querySelectorAll('.editor');
        
        editores.forEach(function(textarea) {
            const editorId = textarea.id;
            
            ClassicEditor
                .create(textarea, {
                    toolbar: [
                        'heading', '|',
                        'bold', 'italic', 'link', '|',
                        'bulletedList', 'numberedList', '|',
                        'imageUpload', 'insertTable', '|',
                        'undo', 'redo'
                    ],
                    language: 'es',
                    image: {
                        toolbar: ['imageTextAlternative']
                    }
                })
                .then(editor => {
                    // Configurar upload adapter manualmente
                    editor.plugins.get('FileRepository').createUploadAdapter = (loader) => {
                        return {
                            upload: () => {
                                return loader.file.then(file => new Promise((resolve, reject) => {
                                    const formData = new FormData();
                                    formData.append('upload', file);
                                    fetch(url_global + '/admin/manual/upload', {
                                        method: 'POST',
                                        body: formData,
                                        headers: {
                                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                                            'Accept': 'application/json'
                                        }
                                    })
                                    .then(response => {
                                        
                                        if (!response.ok) {
                                            throw new Error(`HTTP ${response.status}: ${response.statusText}`);
                                        }
                                        
                                        const contentType = response.headers.get('content-type');
                                        if (!contentType || !contentType.includes('application/json')) {
                                            throw new Error('La respuesta no es JSON válido');
                                        }
                                        
                                        return response.text(); // Obtener como texto primero
                                    })
                                    .then(text => {
                                        try {
                                            const result = JSON.parse(text);
                                            
                                            if (result.url) {
                                                resolve({ default: result.url });
                                            } else {
                                                reject(result.error?.message || 'Error al subir imagen');
                                            }
                                        } catch (parseError) {
                                            reject('Respuesta del servidor no válida');
                                        }
                                    })
                                    .catch(error => {
                                        console.error('Fetch error:', error);
                                        reject('Error de red: ' + error.message);
                                    });
                                }));
                            },
                            abort: () => {
                                console.log('Upload cancelado');
                            }
                        };
                    };

                    // Guardar referencia del editor
                    window[`editor_${editorId}`] = editor;
                    
                    // Sincronizar con textarea
                    editor.model.document.on('change:data', () => {
                        textarea.value = editor.getData();
                    });
                })
                .catch(error => {
                    console.error('Error al inicializar CKEditor:', error);
                });
        });
    });
</script>
@endsection
